import exceptions
import os
import time
import datetime

from wnodes.utils import utils

class MessageStoreError(exceptions.Exception):
    pass

class MessageFormat(object):

    header = 'APEL-cloud-message: v0.1'

    def __init__(self, records_list = []):
        self.records_list = records_list[:]

    def add_record(self, record):
        """Adds a Record"""
        self.records_list.append(record)

    def get_information(self):
        """Gets message information"""
        message = MessageFormat.header
        for record in self.records_list:
            message += record
        return message

    def store_in_file(self, location):
        if not os.path.isdir(location):
            msg = ('The %s location of the file does not exist.'
                % location)
            raise MessageStoreError(msg)
        else:
            suffix = utils.guid()
            try:
                sf = open(os.path.join(location, 'message_%s.txt' % suffix), 'w')
                records = self.get_information()
                sf.write(records)
                sf.close()
            except IOError, err:
                raise MessageStoreError(err)
