/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.italiangrid.voms.VOMSError;

public class EffectiveUserIdProvider {
    private static final String EUID_ENV_VAR = "EUID";
    private static final String EUID_SYSTEM_PROPERTY = "effectiveUserId";
    private static final String EUID_COMMAND = "id -u";

    private static String getEUIDStringFromEnv() {
        return System.getenv(EUID_ENV_VAR);
    }

    private static String getEUIDStringFromSystemProperty() {
        return System.getProperty(EUID_SYSTEM_PROPERTY);
    }

    private static String getEUIDStringFromIdCommand() {
        String euidString = null;
        ProcessBuilder pb = new ProcessBuilder(EUID_COMMAND.split(" "));
        try {
            Process p = pb.start();
            int exitStatus = p.waitFor();
            if (exitStatus != 0) {
                throw new VOMSError("Cannot resolve the user effective id: error invoking the 'id -u' os command!");
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            euidString = r.readLine();
            if (euidString == null) {
                throw new VOMSError("Cannot resolve the user effective id: nothing was found in 'id -u' standard output!");
            }
            return euidString;
        }
        catch (IOException e) {
            throw new VOMSError("Cannot resolve the user effective id: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static int getEUID() {
        int euid = -1;
        String euidString = EffectiveUserIdProvider.getEUIDStringFromEnv();
        if (euidString == null) {
            euidString = EffectiveUserIdProvider.getEUIDStringFromSystemProperty();
        }
        if (euidString == null) {
            euidString = EffectiveUserIdProvider.getEUIDStringFromIdCommand();
        }
        if (euidString != null) {
            euid = Integer.parseInt(euidString);
            return euid;
        }
        throw new VOMSError("Cannot resolve the user effective id!");
    }
}

