/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients.impl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.clients.impl.InitListenerAdapter;
import org.italiangrid.voms.clients.options.ProxyInitOptions;
import org.italiangrid.voms.clients.util.MessageLogger;
import org.italiangrid.voms.clients.util.VOMSAttributesPrinter;
import org.italiangrid.voms.credential.FilePermissionError;
import org.italiangrid.voms.error.VOMSValidationErrorMessage;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSErrorMessage;
import org.italiangrid.voms.request.VOMSResponse;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.VOMSWarningMessage;
import org.italiangrid.voms.store.LSCInfo;

public class ProxyInitListenerHelper
implements InitListenerAdapter {
    MessageLogger logger;
    WARNING_POLICY warningPolicy = WARNING_POLICY.printWarnings;

    public ProxyInitListenerHelper(MessageLogger logger) {
        this.logger = logger;
    }

    public ProxyInitListenerHelper(MessageLogger logger, WARNING_POLICY warnPolicy) {
        this.logger = logger;
        this.warningPolicy = warnPolicy;
    }

    public void notifyVOMSRequestFailure(VOMSACRequest request, VOMSServerInfo endpoint, Throwable error) {
        if (endpoint != null) {
            this.logger.error("Error contacting %s:%d for VO %s: %s\n", endpoint.getURL().getHost(), endpoint.getURL().getPort(), endpoint.getVoName(), error.getMessage());
        } else {
            this.logger.error("None of the contacted servers for %s were capable of returning a valid AC for the user.\n", request.getVoName());
        }
    }

    public void notifyVOMSRequestStart(VOMSACRequest request, VOMSServerInfo si) {
        this.logger.info("Contacting %s:%d [%s] \"%s\"...\n", si.getURL().getHost(), si.getURL().getPort(), si.getVOMSServerDN(), si.getVoName());
    }

    public void notifyVOMSRequestSuccess(VOMSACRequest request, VOMSServerInfo endpoint) {
        this.logger.info("Remote VOMS server contacted succesfully.\n", new Object[0]);
    }

    public void notifyValidationResult(VOMSValidationResult result) {
        if (!result.isValid()) {
            this.logger.error("\nWARNING: VOMS AC validation for VO %s failed for the following reasons:\n", result.getAttributes().getVO());
            for (VOMSValidationErrorMessage m : result.getValidationErrors()) {
                this.logger.error("         %s\n", m.getMessage());
            }
        } else {
            this.logger.trace("VOMS AC validation for VO %s succeded.\n", result.getAttributes().getVO());
            VOMSAttributesPrinter.printVOMSAttributes(this.logger, MessageLogger.MessageLevel.TRACE, result.getAttributes());
        }
    }

    @Override
    public void proxyCreated(String proxyPath, ProxyCertificate cert, List<String> warnings) {
        if (!warnings.isEmpty()) {
            for (String w : warnings) {
                this.logger.warning("WARNING: %s\n", w);
            }
        }
        this.logger.info("\nCreated proxy in %s.\n\n", proxyPath);
        this.logger.info("Your proxy is valid until %s\n", cert.getCredential().getCertificateChain()[0].getNotAfter());
    }

    public boolean onValidationError(ValidationError error) {
        this.logger.warning("Certificate validation error: %s\n", error.getMessage());
        return false;
    }

    public void notifyCertficateLookupEvent(String dir) {
        this.logger.trace("Looking for VOMS AA certificates in %s...\n", dir);
    }

    public void notifyCertificateLoadEvent(X509Certificate cert, File file) {
        String certSubject = X500NameUtils.getReadableForm((X500Principal)cert.getSubjectX500Principal());
        this.logger.trace("Loaded VOMS AA certificate with subject %s from file %s\n", certSubject, file.getAbsolutePath());
    }

    public void notifyLSCLoadEvent(LSCInfo info, File file) {
        this.logger.trace("Loaded LSC information from file %s: %s\n", file.getAbsolutePath(), info.toString());
    }

    public void notifyLSCLookupEvent(String dir) {
        this.logger.trace("Looking for LSC information in %s...\n", dir);
    }

    public void notifyCredentialLookup(String ... locations) {
        this.logger.trace("Looking for user credentials in %s...\n", Arrays.toString(locations));
    }

    public void notifyLoadCredentialSuccess(String ... locations) {
        this.logger.trace("Credentials loaded successfully %s\n", Arrays.toString(locations));
    }

    public void notifyLoadCredentialFailure(Throwable error, String ... locations) {
        MessageLogger.MessageLevel level = MessageLogger.MessageLevel.TRACE;
        if (error instanceof FileNotFoundException) {
            level = MessageLogger.MessageLevel.TRACE;
        } else if (error instanceof FilePermissionError || error instanceof KeyStoreException || error instanceof IOException) {
            level = MessageLogger.MessageLevel.ERROR;
        }
        this.logger.formatMessage(level, "Credentials couldn't be loaded %s: %s\n", Arrays.toString(locations), error.getMessage());
    }

    public void notifyErrorsInVOMSReponse(VOMSACRequest request, VOMSServerInfo si, VOMSErrorMessage[] errors) {
        this.logger.error("VOMS server %s:%d returned the following errors:\n", si.getURL().getHost(), si.getURL().getPort());
        for (VOMSErrorMessage e : errors) {
            this.logger.error("%s\n", e.getMessage());
        }
    }

    public void notifyWarningsInVOMSResponse(VOMSACRequest request, VOMSServerInfo si, VOMSWarningMessage[] warnings) {
        if (!this.warningPolicy.equals((Object)WARNING_POLICY.ignoreWarnings)) {
            for (VOMSWarningMessage e : warnings) {
                this.logger.warning("%s\n", e.getMessage());
            }
            if (this.warningPolicy.equals((Object)WARNING_POLICY.failOnWarnings)) {
                this.logger.trace("Exiting as requested by the --%s option...\n", ProxyInitOptions.FAIL_ON_WARN.getLongOptionName());
                System.exit(1);
            }
        }
    }

    public void notifyNoValidVOMSESError(List<String> searchedPaths) {
        this.logger.info("No valid VOMSES information found locally while looking in: " + searchedPaths, new Object[0]);
    }

    public void notifyVOMSESlookup(String vomsesPath) {
        this.logger.trace("Looking for VOMSES information in %s...\n", vomsesPath);
    }

    public void notifyVOMSESInformationLoaded(String vomsesPath, VOMSServerInfo info) {
        if (vomsesPath != null) {
            this.logger.trace("Loaded vomses information '%s' from %s.\n", info, vomsesPath);
        } else {
            this.logger.trace("Loaded vomses information '%s'\n", info);
        }
    }

    public void loadingNotification(String location, String type, StoreUpdateListener.Severity level, Exception cause) {
        if (location.startsWith("file:")) {
            location = location.substring(5, location.length());
        }
        if (level.equals((Object)StoreUpdateListener.Severity.ERROR)) {
            this.logger.error("Error for %s %s: %s.\n", type, location, cause.getMessage());
        } else if (level.equals((Object)StoreUpdateListener.Severity.WARNING)) {
            this.logger.trace("Warning for %s %s: %s.\n", type, location, cause.getMessage());
        } else if (level.equals((Object)StoreUpdateListener.Severity.NOTIFICATION)) {
            this.logger.trace("Loading %s %s.\n", type, location);
        }
    }

    public void notifyHTTPRequest(String url) {
        this.logger.trace("Sent HTTP request for %s\n", url);
    }

    public void notifyLegacyRequest(String xmlLegacyRequest) {
        if (this.logger.isLevelEnabled(MessageLogger.MessageLevel.TRACE)) {
            this.logger.trace("Sent VOMS legacy request:\n", new Object[0]);
            this.logger.trace(xmlLegacyRequest, new Object[0]);
        }
    }

    public void notifyReceivedResponse(VOMSResponse r) {
        if (this.logger.isLevelEnabled(MessageLogger.MessageLevel.TRACE)) {
            this.logger.trace("Received VOMS response:\n", new Object[0]);
            this.logger.trace(r.getXMLAsString(), new Object[0]);
        }
    }

    public static enum WARNING_POLICY {
        printWarnings,
        failOnWarnings,
        ignoreWarnings;

    }
}

