/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients.impl;

import eu.emi.security.authn.x509.helpers.proxy.ExtendedProxyType;
import eu.emi.security.authn.x509.helpers.proxy.ProxyHelper;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACParser;
import org.italiangrid.voms.asn1.VOMSACUtils;
import org.italiangrid.voms.clients.ProxyInfoParams;
import org.italiangrid.voms.clients.impl.InitListenerAdapter;
import org.italiangrid.voms.clients.strategies.ProxyInfoStrategy;
import org.italiangrid.voms.clients.util.MessageLogger;
import org.italiangrid.voms.clients.util.OpensslNameUtilities;
import org.italiangrid.voms.clients.util.TimeUtils;
import org.italiangrid.voms.clients.util.VOMSAttributesPrinter;
import org.italiangrid.voms.clients.util.VOMSProxyPathBuilder;

public class DefaultVOMSProxyInfoBehaviour
implements ProxyInfoStrategy {
    private PEMCredential proxyCredential;
    private VOMSACParser acParser = null;
    private final String[] keyUsagesValues = new String[]{"Digital Signature", "Non Repudiation", "Key Encipherment", "Data Encipherment", "Key Agreement", "Key CertSign", "CRL Sign", "Encipher Only", "Decipher Only"};
    ArrayList<String> proxyKeyUsageList = new ArrayList();
    private final MessageLogger logger;

    public DefaultVOMSProxyInfoBehaviour(MessageLogger logger, InitListenerAdapter listenerAdapter) {
        this.logger = logger;
    }

    @Override
    public void printProxyInfo(ProxyInfoParams params) {
        ArrayList<VOMSAttribute> attributes = new ArrayList();
        X509Certificate[] proxyChain = null;
        if (params.getProxyFile() == null) {
            params.setProxyFile(VOMSProxyPathBuilder.buildProxyPath());
        }
        FileInputStream proxyInputStream = null;
        try {
            proxyInputStream = new FileInputStream(params.getProxyFile());
        }
        catch (FileNotFoundException e) {
            throw new VOMSError("Proxy not found: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.proxyCredential = new PEMCredential((InputStream)proxyInputStream, (char[])null);
        }
        catch (Exception e) {
            throw new VOMSError("Proxy not found: " + e.getMessage(), (Throwable)e);
        }
        File proxyFilePath = new File(params.getProxyFile());
        proxyChain = this.proxyCredential.getCertificateChain();
        this.acParser = VOMSValidators.newParser();
        attributes = this.acParser.parse(proxyChain);
        this.resolveProxyKeyUsage();
        if (params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS) && !params.containsOption(ProxyInfoParams.PrintOption.CHAIN)) {
            this.printProxyStandardInfo(proxyFilePath);
            this.printAC(attributes);
            this.logger.printMessage("");
        }
        if (params.isEmpty()) {
            this.printProxyStandardInfo(proxyFilePath);
        }
        this.checkProxyBasicOptions(params, attributes, proxyFilePath, proxyChain);
        this.checkVOMSOptions(params, attributes, proxyChain, proxyFilePath);
        this.checkValidityOptions(params, proxyChain);
    }

    private void checkValidityOptions(ProxyInfoParams params, X509Certificate[] proxyChain) {
        int period;
        if (params.containsOption(ProxyInfoParams.PrintOption.PROXY_STRENGTH_VALIDITY) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS) && !this.getKeySize(proxyChain[0]).equals(params.getKeyLength())) {
            throw new VOMSError("Proxy key size is not valid");
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.PROXY_EXISTS)) {
            try {
                try {
                    proxyChain[0].checkValidity();
                }
                catch (CertificateNotYetValidException e) {
                    throw new VOMSError("Proxy not found: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (CertificateExpiredException e) {
                throw new VOMSError("The current proxy is not valid: " + e.getMessage(), (Throwable)e);
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.PROXY_TIME_VALIDITY)) {
            period = 0;
            try {
                period = TimeUtils.parseLifetimeInHoursAndMinutes(params.getValidTime());
            }
            catch (ParseException e) {
                throw new VOMSError("Wrong validity format, required 'hh:mm': " + e.getMessage(), (Throwable)e);
            }
            if (!this.checkTimeValidity(TimeUtils.getTimeLeft(proxyChain[0].getNotAfter()), period)) {
                throw new VOMSError("Proxy not valid for the specified period");
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.PROXY_HOURS_VALIDITY)) {
            period = 0;
            try {
                period = TimeUtils.parseLifetimeInHours(params.getValidHours());
            }
            catch (ParseException e) {
                throw new VOMSError("Wrong validity format, required 'hh': " + e.getMessage(), (Throwable)e);
            }
            if (!this.checkTimeValidity(TimeUtils.getTimeLeft(proxyChain[0].getNotAfter()), period)) {
                throw new VOMSError("Proxy not valid for the specified period");
            }
        }
    }

    private void printProxyChain(X509Certificate[] chain) {
        this.logger.printMessage("=== Proxy Chain Information ===");
        for (X509Certificate c : chain) {
            this.logger.printMessage(CertificateUtils.format((X509Certificate)c, (FormatMode)FormatMode.FULL));
            try {
                if (ProxyUtils.isProxy((X509Certificate)c)) {
                    List attrs = VOMSACUtils.getACsFromCertificate((X509Certificate)c);
                    if (!attrs.isEmpty()) {
                        this.logger.printMessage("VOMS extensions: yes.");
                    } else {
                        this.logger.printMessage("VOMS extensions: no.");
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.logger.printMessage("");
        }
    }

    private void checkProxyBasicOptions(ProxyInfoParams params, List<VOMSAttribute> listVOMSAttributes, File proxyFilePath, X509Certificate[] proxyChain) {
        if (params.containsOption(ProxyInfoParams.PrintOption.TYPE) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            this.logger.printMessage(this.proxyTypeAsString(proxyChain[0]));
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.SUBJECT) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            this.logger.printMessage(OpensslNameUtilities.getOpensslSubjectString(proxyChain[0].getSubjectX500Principal()));
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.ISSUER) || params.containsOption(ProxyInfoParams.PrintOption.IDENTITY) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            this.logger.printMessage(OpensslNameUtilities.getOpensslSubjectString(proxyChain[0].getIssuerX500Principal()));
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.PROXY_PATH) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            this.logger.printMessage(proxyFilePath.getAbsolutePath());
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.CHAIN)) {
            this.printProxyChain(proxyChain);
            this.logger.printMessage("=== Proxy Information ===");
            this.printProxyStandardInfo(proxyFilePath);
            if (params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
                this.printAC(listVOMSAttributes);
            }
            this.logger.printMessage("");
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.TEXT)) {
            if (!params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS) && !params.containsOption(ProxyInfoParams.PrintOption.CHAIN)) {
                this.printProxyStandardInfo(proxyFilePath);
                this.logger.printMessage("");
            }
            int chainLength = 1;
            if (params.containsOption(ProxyInfoParams.PrintOption.CHAIN)) {
                chainLength = proxyChain.length;
            }
            for (int i = chainLength - 1; i >= 0; --i) {
                this.logger.printMessage("Certificate:");
                this.logger.printMessage(CertificateUtils.format((X509Certificate)proxyChain[i], (FormatMode)FormatMode.FULL));
                this.logger.printMessage("");
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.KEYSIZE) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            this.logger.printMessage(this.getKeySize(proxyChain[0]));
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.KEYUSAGE) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            this.tabularFormatted("key usage", this.getProxyKeyUsages());
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.TIMELEFT) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            Date endDate = this.proxyCredential.getCertificate().getNotAfter();
            this.logger.printMessage(TimeUtils.getValidityAsString(endDate));
        }
    }

    private void checkVOMSOptions(ProxyInfoParams params, List<VOMSAttribute> attributes, X509Certificate[] proxyChain, File proxyFilePath) {
        if (params.hasACOptions() && attributes.isEmpty()) {
            throw new VOMSError("No VOMS attributes found!");
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.ACSUBJECT) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            for (VOMSAttribute a : attributes) {
                this.logger.printMessage(OpensslNameUtilities.getOpensslSubjectString(a.getHolder()));
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.ACTIMELEFT) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            for (VOMSAttribute a : attributes) {
                this.logger.printMessage(TimeUtils.getValidityAsString(a.getVOMSAC().getNotAfter()));
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.ACISSUER) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            for (VOMSAttribute a : attributes) {
                this.logger.printMessage(OpensslNameUtilities.getOpensslSubjectString(a.getAACertificates()[0].getSubjectX500Principal()));
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.ACSERIAL) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            for (VOMSAttribute a : attributes) {
                this.logger.printMessage(a.getVOMSAC().getSerialNumber().toString());
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.AC_EXISTS)) {
            boolean foundRequestedAC = false;
            for (VOMSAttribute a : attributes) {
                if (!params.getACVO().equals(a.getVO())) continue;
                foundRequestedAC = true;
                break;
            }
            if (!foundRequestedAC) {
                throw new VOMSError("AC not found for VO " + params.getACVO());
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.VONAME) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            for (VOMSAttribute a : attributes) {
                this.logger.printMessage(a.getVO());
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.FQAN) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            for (VOMSAttribute a : attributes) {
                for (String f : a.getFQANs()) {
                    this.logger.printMessage(f);
                }
            }
        }
        if (params.containsOption(ProxyInfoParams.PrintOption.SERVER_URI) && !params.containsOption(ProxyInfoParams.PrintOption.ALL_OPTIONS)) {
            for (VOMSAttribute a : attributes) {
                this.logger.formatMessage("%s:%s\n", a.getHost(), a.getPort());
            }
        }
    }

    private void resolveProxyKeyUsage() {
        boolean[] keyUsages = this.proxyCredential.getCertificate().getKeyUsage();
        int index = 0;
        for (boolean key : keyUsages) {
            if (key) {
                this.proxyKeyUsageList.add(this.keyUsagesValues[index]);
            }
            ++index;
        }
    }

    private String getProxyKeyUsages() {
        StringBuilder usage = new StringBuilder();
        Iterator<String> it = this.proxyKeyUsageList.iterator();
        if (it.hasNext()) {
            usage.append(it.next());
        }
        while (it.hasNext()) {
            usage.append(", " + it.next());
        }
        return usage.toString();
    }

    private void printAC(List<VOMSAttribute> listVOMSAttributes) {
        for (VOMSAttribute a : listVOMSAttributes) {
            VOMSAttributesPrinter.printVOMSAttributes(this.logger, MessageLogger.MessageLevel.INFO, a);
        }
    }

    private void printProxyStandardInfo(File proxyFilePath) {
        String subject = OpensslNameUtilities.getOpensslSubjectString(this.proxyCredential.getCertificate().getSubjectX500Principal());
        String issuer = OpensslNameUtilities.getOpensslSubjectString(this.proxyCredential.getCertificate().getIssuerX500Principal());
        String holder = OpensslNameUtilities.getOpensslSubjectString(ProxyUtils.getOriginalUserDN((X509Certificate[])this.proxyCredential.getCertificateChain()));
        this.tabularFormatted("subject", subject);
        this.tabularFormatted("issuer", issuer);
        this.tabularFormatted("identity", holder);
        this.tabularFormatted("type", this.proxyTypeAsString(this.proxyCredential.getCertificate()));
        this.tabularFormatted("strength", this.getKeySize(this.proxyCredential.getCertificate()));
        this.tabularFormatted("path", proxyFilePath.getAbsolutePath());
        this.tabularFormatted("timeleft", TimeUtils.getValidityAsString(this.proxyCredential.getCertificate().getNotAfter()));
        this.tabularFormatted("key usage", this.getProxyKeyUsages());
    }

    private String proxyTypeAsString(X509Certificate proxyCert) {
        boolean limited;
        ExtendedProxyType pt = ProxyHelper.getProxyType((X509Certificate)proxyCert);
        try {
            limited = ProxyHelper.isLimited((X509Certificate)proxyCert);
        }
        catch (IOException e) {
            throw new VOMSError("Error checking proxy policy:" + e.getMessage(), (Throwable)e);
        }
        String typeString = null;
        switch (pt) {
            case LEGACY: {
                typeString = String.format("%s legacy globus proxy", limited ? "limited" : "full");
                break;
            }
            case DRAFT_RFC: {
                typeString = String.format("Proxy draft (pre-RFC) %s proxy", limited ? "limited" : "impersonation");
                break;
            }
            case RFC3820: {
                typeString = String.format("RFC3820 compliant %s proxy", limited ? "limited" : "impersonation");
                break;
            }
            case NOT_A_PROXY: {
                typeString = "EEC";
            }
        }
        return typeString;
    }

    private boolean checkTimeValidity(long certTimeLeft, int period) {
        long msPeriod = period * 1000;
        return certTimeLeft >= msPeriod;
    }

    private String getKeySize(X509Certificate chain) {
        RSAKey rsaKey = (RSAKey)((Object)chain.getPublicKey());
        return Integer.toString(rsaKey.getModulus().bitLength());
    }

    private void tabularFormatted(String name, String value) {
        this.logger.printMessage(String.format("%-9s %s %s", name, ":", value));
    }
}

