/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.italiangrid.voms.clients.AbstractCLI;
import org.italiangrid.voms.clients.ProxyDestroyParams;
import org.italiangrid.voms.clients.impl.DefaultProxyDestroyBehaviour;
import org.italiangrid.voms.clients.impl.ProxyDestroyListenerHelper;
import org.italiangrid.voms.clients.options.CLIOption;
import org.italiangrid.voms.clients.options.ProxyDestroyOptions;

public class VomsProxyDestroy
extends AbstractCLI {
    private static final String COMMAND_NAME = "voms-proxy-destroy";
    private ProxyDestroyListenerHelper listenerHelper;

    public static void main(String[] args) {
        new VomsProxyDestroy(args);
    }

    public VomsProxyDestroy(String[] args) {
        super(COMMAND_NAME);
        this.initOptions();
        this.parseOptionsFromCommandLine(args);
        this.listenerHelper = new ProxyDestroyListenerHelper(this.logger);
        this.execute();
    }

    private void initOptions() {
        ArrayList<CLIOption> options = new ArrayList<CLIOption>();
        options.addAll(Arrays.asList(ProxyDestroyOptions.values()));
        this.initOptions(options);
    }

    @Override
    protected void execute() {
        ProxyDestroyParams params = this.getProxyDestroyParamsFromCommandLine(this.commandLine);
        new DefaultProxyDestroyBehaviour(this.listenerHelper).destroyProxy(params);
    }

    private ProxyDestroyParams getProxyDestroyParamsFromCommandLine(CommandLine commandLine) {
        ProxyDestroyParams params = new ProxyDestroyParams();
        if (this.commandLineHasOption(ProxyDestroyOptions.DRY)) {
            params.setDryRun(true);
        }
        if (this.commandLineHasOption(ProxyDestroyOptions.FILE)) {
            params.setProxyFile(this.getOptionValue(ProxyDestroyOptions.FILE));
        }
        return params;
    }
}

