/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.italiangrid.voms.clients.AbstractCLI;
import org.italiangrid.voms.clients.ProxyInfoParams;
import org.italiangrid.voms.clients.impl.DefaultVOMSProxyInfoBehaviour;
import org.italiangrid.voms.clients.impl.ProxyInfoListenerHelper;
import org.italiangrid.voms.clients.options.CLIOption;
import org.italiangrid.voms.clients.options.CommonOptions;
import org.italiangrid.voms.clients.options.ProxyInfoOptions;
import org.italiangrid.voms.clients.strategies.ProxyInfoStrategy;

public class VomsProxyInfo
extends AbstractCLI {
    private static final String COMMAND_NAME = "voms-proxy-info";
    private static final int EXIT_ERROR_CODE = 1;
    private ProxyInfoStrategy proxyInfoBehaviour;
    private final ProxyInfoListenerHelper listenerHelper;

    protected VomsProxyInfo(String[] args) {
        super(COMMAND_NAME);
        this.initOptions();
        this.parseOptionsFromCommandLine(args);
        this.listenerHelper = new ProxyInfoListenerHelper(this.logger);
        this.execute();
    }

    private void initOptions() {
        ArrayList<CLIOption> options = new ArrayList<CLIOption>();
        options.addAll(Arrays.asList(CommonOptions.values()));
        options.addAll(Arrays.asList(ProxyInfoOptions.values()));
        this.initOptions(options);
    }

    private ProxyInfoParams getProxyInfoParamsFromCommandLine(CommandLine commandLine) {
        ProxyInfoParams params = new ProxyInfoParams();
        if (this.commandLineHasOption(ProxyInfoOptions.PROXY_FILENAME)) {
            params.setProxyFile(this.getOptionValue(ProxyInfoOptions.PROXY_FILENAME));
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_TEXT)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.TEXT);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_CHAIN)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.CHAIN);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_ALL_OPTIONS)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.ALL_OPTIONS);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_TYPE)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.TYPE);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_SUBJECT)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.SUBJECT);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_ISSUER)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.ISSUER);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_IDENTITY)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.IDENTITY);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_PROXY_PATH)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.PROXY_PATH);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_KEYSIZE)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.KEYSIZE);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_TIMELEFT)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.TIMELEFT);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_VONAME)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.VONAME);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_ACISSUER)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.ACISSUER);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_ACSUBJECT)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.ACSUBJECT);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_ACSERIAL)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.ACSERIAL);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_ACTIMELEFT)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.ACTIMELEFT);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_FQAN)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.FQAN);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_KEYUSAGE)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.KEYUSAGE);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PRINT_SERVER_URI)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.SERVER_URI);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PROXY_TIME_VALIDITY)) {
            params.setValidTime(this.getOptionValue(ProxyInfoOptions.PROXY_TIME_VALIDITY));
            params.addPrintOption(ProxyInfoParams.PrintOption.PROXY_TIME_VALIDITY);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PROXY_HOURS_VALIDITY)) {
            params.setValidHours(this.getOptionValue(ProxyInfoOptions.PROXY_HOURS_VALIDITY));
            params.addPrintOption(ProxyInfoParams.PrintOption.PROXY_HOURS_VALIDITY);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PROXY_STRENGTH_VALIDITY)) {
            params.setKeyLength(this.getOptionValue(ProxyInfoOptions.PROXY_STRENGTH_VALIDITY));
            params.addPrintOption(ProxyInfoParams.PrintOption.PROXY_STRENGTH_VALIDITY);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.PROXY_EXISTS)) {
            params.addPrintOption(ProxyInfoParams.PrintOption.PROXY_EXISTS);
        }
        if (this.commandLineHasOption(ProxyInfoOptions.AC_EXISTS)) {
            params.setACVO(this.getOptionValue(ProxyInfoOptions.AC_EXISTS));
            params.addPrintOption(ProxyInfoParams.PrintOption.AC_EXISTS);
        }
        return params;
    }

    @Override
    protected void execute() {
        ProxyInfoParams params = this.getProxyInfoParamsFromCommandLine(this.commandLine);
        try {
            this.proxyInfoBehaviour = new DefaultVOMSProxyInfoBehaviour(this.logger, this.listenerHelper);
            this.proxyInfoBehaviour.printProxyInfo(params);
            System.exit(0);
        }
        catch (Throwable t) {
            this.logger.error(t);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new VomsProxyInfo(args);
    }
}

