/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.clients.options.CLIOption;
import org.italiangrid.voms.clients.options.CommonOptions;
import org.italiangrid.voms.clients.options.ProxyInitOptions;
import org.italiangrid.voms.clients.util.MessageLogger;
import org.italiangrid.voms.clients.util.OptionsFileLoader;
import org.italiangrid.voms.clients.util.VersionProvider;

public abstract class AbstractCLI {
    public static final String DEFAULT_TMP_PATH = "/tmp";
    protected Options cliOptions;
    protected CommandLineParser cliParser = new GnuParser();
    protected CommandLine commandLine = null;
    protected String commandName;
    protected MessageLogger logger;
    boolean isQuiet = false;
    boolean isVerbose = false;

    protected AbstractCLI(String commandName) {
        this.commandName = commandName;
    }

    protected final void displayUsage() {
        int lineWidth = 120;
        String header = "options:";
        String footer = "";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(lineWidth, this.commandName + " [options]", header, this.cliOptions, footer);
    }

    protected final void parseOptionsFromCommandLine(String[] args) {
        try {
            this.commandLine = this.cliParser.parse(this.cliOptions, args);
            if (this.commandLineHasOption(CommonOptions.CONF)) {
                this.parseOptionsFromFile(this.getOptionValue(CommonOptions.CONF));
            }
            this.setVerbosityFromCommandLine();
            this.displayVersionIfRequested();
            this.displayHelpIfRequested();
        }
        catch (ParseException e) {
            System.err.println("Error parsing command line arguments: " + e.getMessage());
            this.displayUsage();
            System.exit(1);
        }
    }

    private void parseOptionsFromFile(String optionFileName) throws ParseException {
        List<String> options = OptionsFileLoader.loadOptions(optionFileName);
        options.addAll(this.commandLine.getArgList());
        this.commandLine = this.cliParser.parse(this.cliOptions, options.toArray(new String[0]));
    }

    protected final void displayVersion() {
        VersionProvider.displayVersionInfo(this.commandName);
    }

    protected final void initOptions(List<CLIOption> options) {
        this.cliOptions = new Options();
        for (CLIOption o : options) {
            this.cliOptions.addOption(o.getOption());
        }
    }

    protected final boolean commandLineHasOption(CLIOption option) {
        return this.commandLine.hasOption(option.getLongOptionName());
    }

    protected final void displayHelpIfRequested() {
        if (this.commandLineHasOption(CommonOptions.HELP) || this.commandLineHasOption(CommonOptions.USAGE)) {
            this.displayUsage();
            System.exit(0);
        }
    }

    protected final void displayVersionIfRequested() {
        if (this.commandLineHasOption(CommonOptions.VERSION)) {
            this.displayVersion();
            System.exit(0);
        }
    }

    protected final String getOptionValue(CLIOption option) {
        if (this.commandLineHasOption(option)) {
            return this.commandLine.getOptionValue(option.getLongOptionName());
        }
        return null;
    }

    protected final List<String> getOptionValues(CLIOption option) {
        if (this.commandLineHasOption(option)) {
            String[] values = this.commandLine.getOptionValues(option.getLongOptionName());
            return Arrays.asList(values);
        }
        return null;
    }

    protected final void setVerbosityFromCommandLine() {
        if (this.commandLineHasOption(CommonOptions.DEBUG)) {
            this.isVerbose = true;
        }
        if (this.commandLineHasOption(ProxyInitOptions.QUIET_MODE)) {
            this.isQuiet = true;
        }
        if (this.isVerbose && this.isQuiet) {
            throw new VOMSError("Try to understand us: this command cannot be verbose and quiet at the same time!");
        }
        if (this.isVerbose) {
            this.logger = new MessageLogger(MessageLogger.VERBOSE);
        }
        if (this.isQuiet) {
            this.logger = new MessageLogger(MessageLogger.QUIET);
        }
        if (!this.isVerbose && !this.isQuiet) {
            this.logger = new MessageLogger();
        }
    }

    protected abstract void execute();

    static {
        CertificateUtils.configureSecProvider();
    }
}

