/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.VOMSKeyManager;
import org.glite.voms.VOMSTrustManager;
import org.glite.voms.contact.UserCredentials;

public class VOMSSocket {
    private static final Logger log = Logger.getLogger(VOMSSocket.class);
    UserCredentials cred;
    String hostDN;
    private SSLContext context = null;
    private SSLSocket socket = null;

    public static VOMSSocket instance(UserCredentials cred, String hostDN, int proxyType) {
        return new VOMSSocket(cred, hostDN, proxyType);
    }

    public static VOMSSocket instance(UserCredentials cred, String hostDN) {
        return new VOMSSocket(cred, hostDN, 2);
    }

    private VOMSSocket(UserCredentials cred, String hostDN, int proxyType) {
        this.cred = cred;
        this.hostDN = hostDN;
    }

    protected SSLSocketFactory getFactory() throws IOException, GeneralSecurityException {
        Object socketFactory = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        log.debug((Object)"Creating socket Factory");
        try {
            this.context = SSLContext.getInstance("SSLv3");
            log.debug((Object)("CONTEXT CREATED: " + this.context.getProtocol()));
            log.debug((Object)("Context: " + this.context));
            this.context.init(new VOMSKeyManager[]{new VOMSKeyManager(this.cred)}, new VOMSTrustManager[]{new VOMSTrustManager("")}, SecureRandom.getInstance("SHA1PRNG"));
            return this.context.getSocketFactory();
        }
        catch (SSLException e) {
            log.fatal((Object)("Error opening SSL socket: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            log.fatal((Object)("Error opening SSL socket: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected void connect(String host, int port) throws IOException, GeneralSecurityException {
        SSLSocketFactory socketFactory = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        log.debug((Object)"Initting CONNECCTION");
        try {
            socketFactory = this.getFactory();
            log.debug((Object)"Factory Created");
            log.debug((Object)socketFactory.toString());
            log.debug((Object)"ABOUT to open CONNECTION");
            this.socket = (SSLSocket)socketFactory.createSocket(host, port);
            log.debug((Object)"CONNECTION OPEN");
            String[] protocols = new String[]{"SSLv3"};
            this.socket.setEnabledProtocols(protocols);
        }
        catch (SSLException e) {
            log.fatal((Object)("Error opening SSL socket: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            log.fatal((Object)("Error opening SSL socket: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public SSLContext getContext() {
        return this.context;
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            return this.socket.getOutputStream();
        }
        catch (IOException e) {
            log.error((Object)("Error getting output stream from underlying socket:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.socket.getInputStream();
        }
        catch (IOException e) {
            log.error((Object)("Error getting input stream from underlying socket:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }
}

