/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.voms.PKIUtils;
import org.glite.voms.contact.VOMSException;

public class UserCredentials {
    private static final Logger log;
    private X509Certificate userCert;
    private X509Certificate[] userChain;
    private PrivateKey userKey;

    private UserCredentials(PrivateKey key, X509Certificate[] certs) {
        this.userKey = key;
        this.userCert = certs[0];
        this.userChain = certs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cert is: " + certs[0].getSubjectDN()));
            for (int i = 0; i < this.userChain.length; ++i) {
                log.debug((Object)("Chain[" + i + "] is: " + this.userChain[i].getSubjectDN()));
            }
        }
    }

    public void save(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os);
        PEMWriter writer = new PEMWriter((Writer)osw);
        log.debug((Object)("Cert is: " + this.userCert.getSubjectDN()));
        writer.writeObject((Object)this.userCert);
        if (this.userKey != null) {
            writer.writeObject((Object)this.userKey);
        }
        for (int i = 1; i < this.userChain.length; ++i) {
            log.debug((Object)("Chain[" + i + "] is: " + this.userChain[i].getSubjectDN()));
            writer.writeObject((Object)this.userChain[i]);
        }
        writer.flush();
    }

    public X509Certificate getUserCertificate() {
        return this.userCert;
    }

    public X509Certificate[] getUserChain() {
        return this.userChain;
    }

    public PrivateKey getUserKey() {
        return this.userKey;
    }

    private void loadCert(File userCertFile) {
        try {
            this.userChain = PKIUtils.loadCertificates(userCertFile);
            this.userCert = this.userChain[0];
        }
        catch (CertificateException e) {
            log.debug((Object)("Error parsing user certificate: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    private void loadKey(File userKeyFile, String password) {
        log.debug((Object)("File is: " + userKeyFile.getName()));
        this.userKey = PKIUtils.loadPrivateKey(userKeyFile, (PasswordFinder)new PFinder(password));
    }

    private void loadCredentials(File userCertFile, File userKeyFile, String keyPassword) {
        this.loadCert(userCertFile);
        this.loadKey(userKeyFile, keyPassword);
    }

    private void loadPKCS12Credentials(File pkcs12File, String keyPassword) {
        FileInputStream stream = null;
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
            stream = new FileInputStream(pkcs12File);
            ks.load(stream, keyPassword.toCharArray());
            Enumeration<String> aliases = ks.aliases();
            if (!aliases.hasMoreElements()) {
                throw new VOMSException("No aliases found inside pkcs12 certificate!");
            }
            String alias = aliases.nextElement();
            this.userChain = (X509Certificate[])ks.getCertificateChain(alias);
            this.userCert = (X509Certificate)ks.getCertificate(alias);
            this.userKey = (PrivateKey)ks.getKey(alias, keyPassword.toCharArray());
        }
        catch (Exception e) {
            log.error((Object)("Error importing pkcs12 certificate: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)("Error importing pkcs12 certificate: " + e.getMessage()), (Throwable)e);
            }
            throw new VOMSException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private UserCredentials(UserCredentials credentials) {
        this.userChain = credentials.getUserChain();
        this.userKey = credentials.getUserKey();
        this.userCert = credentials.getUserCertificate();
    }

    private UserCredentials(String keyPassword) {
        String pkcs12UserKeyPassword;
        String pkcs12UserCert;
        String x509UserKeyPassword;
        block12: {
            String x509UserCert = System.getProperty("X509_USER_CERT", null);
            String x509UserKey = System.getProperty("X509_USER_KEY", null);
            x509UserKeyPassword = System.getProperty("X509_USER_KEY_PASSWORD", null);
            pkcs12UserCert = System.getProperty("PKCS12_USER_CERT", null);
            pkcs12UserKeyPassword = System.getProperty("PKCS12_USER_KEY_PASSWORD", null);
            if (x509UserCert != null && x509UserKey != null) {
                log.debug((Object)("Looking for pem certificates in (" + x509UserCert + "," + x509UserKey + ")"));
                try {
                    this.loadCredentials(new File(x509UserCert), new File(x509UserKey), x509UserKeyPassword != null ? x509UserKeyPassword : keyPassword);
                    log.debug((Object)"Credentials loaded succesfully.");
                    return;
                }
                catch (VOMSException e) {
                    log.debug((Object)("Error parsing credentials:" + e.getMessage()));
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        log.debug((Object)("Looking for pem certificates in " + System.getProperty("user.home") + File.separator + ".globus"));
        File globusCert = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.pem");
        File globusKey = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "userkey.pem");
        try {
            this.loadCredentials(globusCert, globusKey, x509UserKeyPassword != null ? x509UserKeyPassword : keyPassword);
            log.debug((Object)"Credentials loaded succesfully.");
            return;
        }
        catch (VOMSException e) {
            File pkcs12File;
            block13: {
                log.debug((Object)("Error parsing credentials:" + e.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                if (pkcs12UserCert != null) {
                    log.debug((Object)("Looking for pkcs12 certificate in " + pkcs12UserCert));
                    pkcs12File = null;
                    try {
                        pkcs12File = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.p12");
                        this.loadPKCS12Credentials(pkcs12File, pkcs12UserKeyPassword != null ? pkcs12UserKeyPassword : keyPassword);
                        log.debug((Object)"Credentials loaded succesfully.");
                        return;
                    }
                    catch (VOMSException e2) {
                        log.debug((Object)("Error parsing credentials from " + pkcs12File + ":" + e2.getMessage()));
                        if (!log.isDebugEnabled()) break block13;
                        log.debug((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            log.debug((Object)("Looking for pkcs12 certificate in " + System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.p12"));
            pkcs12File = null;
            try {
                pkcs12File = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "usercert.p12");
                this.loadPKCS12Credentials(pkcs12File, pkcs12UserKeyPassword != null ? pkcs12UserKeyPassword : keyPassword);
                log.debug((Object)"Credentials loaded succesfully.");
                return;
            }
            catch (VOMSException e3) {
                log.debug((Object)("Error parsing credentials from " + pkcs12File + ":" + e3.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)e3.getMessage(), (Throwable)e3);
                }
                throw new VOMSException("No user credentials found!");
            }
        }
    }

    private UserCredentials(String userCertFile, String userKeyFile, String keyPassword) {
        this.loadCredentials(new File(userCertFile), new File(userKeyFile), keyPassword);
    }

    public static UserCredentials instance() {
        return new UserCredentials((String)null);
    }

    public static UserCredentials instance(String keyPassword) {
        return new UserCredentials(keyPassword);
    }

    public static UserCredentials instance(String userCertFile, String userKeyFile, String keyPassword) {
        return new UserCredentials(userCertFile, userKeyFile, keyPassword);
    }

    public static UserCredentials instance(String userCertFile, String userKeyFile) {
        return UserCredentials.instance(userCertFile, userKeyFile, null);
    }

    public static UserCredentials instance(UserCredentials credentials) {
        return new UserCredentials(credentials);
    }

    public static UserCredentials instance(PrivateKey key, X509Certificate[] certs) {
        return new UserCredentials(key, certs);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        log = Logger.getLogger(UserCredentials.class);
    }

    private static class PFinder
    implements PasswordFinder {
        private String pwd;

        public PFinder(String password) {
            this.pwd = password;
        }

        public char[] getPassword() {
            if (this.pwd != null) {
                return this.pwd.toCharArray();
            }
            return "".toCharArray();
        }
    }
}

