/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.PKIUtils;

class GSIVerifier
implements HostnameVerifier {
    private String name;
    private HostnameVerifier verifier;
    private static final Logger log = Logger.getLogger(GSIVerifier.class);

    public GSIVerifier(HostnameVerifier defaultVerifier, String DN) {
        this.name = DN;
        this.verifier = defaultVerifier;
    }

    public boolean verify(String hostname, SSLSession session) {
        boolean res = false;
        if (!this.verifier.verify(hostname, session)) {
            try {
                X509Certificate c = (X509Certificate)session.getPeerCertificates()[0];
                String normal = PKIUtils.getOpenSSLFormatPrincipal(c.getSubjectDN(), false);
                String reversed = PKIUtils.getOpenSSLFormatPrincipal(c.getSubjectDN(), true);
                res = PKIUtils.DNCompare(this.name, normal) || PKIUtils.DNCompare(this.name, reversed);
                log.debug((Object)("result of DN verifier: " + res));
            }
            catch (SSLPeerUnverifiedException e) {
                log.debug((Object)"Unauthenticate peer.  Verify failed.");
                res = false;
            }
        } else {
            res = true;
            log.debug((Object)"Verified by default verifier");
        }
        return res;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

