/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.glite.voms.ac.ObjectDigestInfo;

public class V2Form
implements DEREncodable {
    GeneralNames issuerName;
    IssuerSerial baseCertificateID;
    ObjectDigestInfo objectDigestInfo;

    public V2Form(GeneralNames issuerName) {
        this.issuerName = issuerName;
    }

    public V2Form(ASN1Sequence seq) {
        int n = 0;
        if (seq.getObjectAt(0) instanceof ASN1Sequence) {
            this.issuerName = new GeneralNames((ASN1Sequence)seq.getObjectAt(0));
            ++n;
        }
        while (n < seq.size()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)seq.getObjectAt(n);
            switch (tObj.getTagNo()) {
                case 0: {
                    this.baseCertificateID = new IssuerSerial((ASN1Sequence)tObj.getObject());
                    break;
                }
                case 1: {
                    this.objectDigestInfo = new ObjectDigestInfo((ASN1Sequence)tObj.getObject());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag " + tObj.getTagNo() + " in V2Form");
                }
            }
            ++n;
        }
    }

    public GeneralNames getIssuerName() {
        return this.issuerName;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.issuerName != null) {
            v.add(((ASN1Sequence)this.issuerName.getDERObject()).getObjectAt(0));
        }
        if (this.baseCertificateID != null) {
            v.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)this.baseCertificateID));
        }
        if (this.objectDigestInfo != null) {
            v.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)this.objectDigestInfo));
        }
        return new DERSequence(v);
    }
}

