/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.glite.voms.ac.NameConverter;

public class ACTarget
implements DEREncodable {
    private GeneralName name;
    private GeneralName group;
    private IssuerSerial cert;

    public ACTarget() {
        this.name = null;
        this.group = null;
        this.cert = null;
    }

    public String toString() {
        if (this.name != null) {
            return this.getName();
        }
        if (this.group != null) {
            return this.getGroup();
        }
        if (this.cert != null) {
            return this.getIssuerSerialString();
        }
        return "";
    }

    public String getName() {
        return NameConverter.getInstance(this.name).getAsString();
    }

    public String getGroup() {
        return NameConverter.getInstance(this.group).getAsString();
    }

    public IssuerSerial getIssuerSerial() {
        return this.cert;
    }

    public String getIssuerSerialString() {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)this.cert.getIssuer().getDERObject());
        GeneralName name = GeneralName.getInstance((Object)seq.getObjectAt(0));
        return NameConverter.getInstance(name).getAsString() + ":" + this.cert.getSerial().toString();
    }

    public void setName(GeneralName n) {
        this.name = n;
    }

    public void setName(String s) {
        this.name = new GeneralName((DERObject)new DERIA5String(s), 6);
    }

    public void setGroup(GeneralName g) {
        this.group = g;
    }

    public void setGroup(String s) {
        this.group = new GeneralName((DERObject)new DERIA5String(s), 6);
    }

    public void setIssuerSerial(IssuerSerial is) {
        this.cert = is;
    }

    public void setIssuerSerial(String s) {
        int ch = s.lastIndexOf(58);
        if (ch == -1) {
            throw new IllegalArgumentException("cannot identify issuer and serial");
        }
        String iss = s.substring(0, ch);
        GeneralName nm = new GeneralName((DERObject)new DERIA5String(iss), 6);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)this.name.getDERObject());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)nm);
        v.add((DEREncodable)seq);
        this.cert = new IssuerSerial((ASN1Sequence)new DERSequence(v));
    }

    public static ACTarget getInstance(ASN1Sequence seq) {
        return new ACTarget(seq);
    }

    public ACTarget(ASN1Sequence seq) {
        this.group = null;
        this.name = null;
        this.cert = null;
        for (int i = 0; i <= seq.size(); ++i) {
            if (seq.getObjectAt(i) instanceof ASN1TaggedObject) {
                ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(i);
                switch (obj.getTagNo()) {
                    case 0: {
                        this.group = null;
                        this.cert = null;
                        this.name = GeneralName.getInstance((ASN1TaggedObject)obj, (boolean)true);
                        break;
                    }
                    case 1: {
                        this.cert = null;
                        this.group = GeneralName.getInstance((ASN1TaggedObject)obj, (boolean)true);
                        this.name = null;
                        break;
                    }
                    case 2: {
                        this.group = null;
                        this.name = null;
                        this.cert = new IssuerSerial((ASN1Sequence)obj.getObject());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad tag in encoding ACTarget");
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Bad value type encoding ACTarget");
        }
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.name != null) {
            v.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)this.name));
        }
        if (this.group != null) {
            v.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)this.group));
        }
        if (this.cert != null) {
            v.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)this.cert));
        }
        return new DERSequence(v);
    }
}

