/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.glite.voms.DirectoryList;
import org.glite.voms.FileCertReader;
import org.glite.voms.PKIStore;
import org.glite.voms.ac.ACTrustStore;

public final class BasicVOMSTrustStore
implements ACTrustStore {
    static Logger log = Logger.getLogger(BasicVOMSTrustStore.class);
    public static final String DEFAULT_TRUST_STORE_LISTING = PKIStore.DEFAULT_VOMSDIR;
    String trustedDirList = null;
    private Hashtable issuerCerts = new Hashtable();
    private long refreshPeriod = -1L;
    private Timer theTimer = null;

    public BasicVOMSTrustStore() {
        this(DEFAULT_TRUST_STORE_LISTING, 300000L);
    }

    public BasicVOMSTrustStore(String trustedDirList, long refreshPeriod) {
        List l;
        if (refreshPeriod < 0L) {
            throw new IllegalArgumentException("refreshPeriod is negative");
        }
        try {
            l = new DirectoryList(trustedDirList).getListing();
        }
        catch (IOException e) {
            l = null;
        }
        if (l == null || l.isEmpty()) {
            String msg = "VOMS trust anchors " + trustedDirList + " does not appear to exist";
            log.fatal((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        this.trustedDirList = trustedDirList;
        this.refreshPeriod = refreshPeriod;
        if (refreshPeriod == 0L) {
            this.refresh();
        }
        if (refreshPeriod > 0L) {
            this.theTimer = new Timer(true);
            this.theTimer.scheduleAtFixedRate((TimerTask)new Refreshener(), 0L, refreshPeriod);
        }
    }

    public String getDirList() {
        return this.trustedDirList;
    }

    public void stopRefresh() {
        if (this.theTimer != null) {
            this.theTimer.cancel();
        }
        this.theTimer = null;
    }

    public void refresh() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refreshing in-memory VOMS issuer cache from " + this.trustedDirList));
            }
            Hashtable<X500Principal, Vector<X509Certificate>> newTable = new Hashtable<X500Principal, Vector<X509Certificate>>();
            Vector certs = new FileCertReader().readCerts(this.trustedDirList);
            for (X509Certificate cert : certs) {
                X500Principal key = cert.getSubjectX500Principal();
                Vector<X509Certificate> l = (Vector<X509Certificate>)newTable.get(key);
                if (l == null) {
                    l = new Vector<X509Certificate>();
                }
                l.add(cert);
                newTable.put(key, l);
            }
            this.issuerCerts = newTable;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refreshing of in-memory VOMS issuer cache done. Read " + certs.size() + " certs"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Unexpected error while refreshing in-memory VOMS issuer cache from " + this.trustedDirList + " : " + e.getMessage()));
        }
    }

    public X509Certificate[] getAACandidate(X500Principal issuer) {
        List l;
        if (this.refreshPeriod < 0L) {
            this.refresh();
        }
        if ((l = (List)this.issuerCerts.get(issuer)) != null) {
            return l.toArray(new X509Certificate[l.size()]);
        }
        return null;
    }

    private class Refreshener
    extends TimerTask {
        private Refreshener() {
        }

        public void run() {
            BasicVOMSTrustStore.this.refresh();
        }
    }
}

