/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;

public class Util {
    public static GeneralNames generalNameToGeneralNames(GeneralName name) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)name);
        return GeneralNames.getInstance((Object)new DERSequence(v));
    }

    public static GeneralName x500nameToGeneralName(byte[] encodedName) {
        try {
            return new GeneralName((X509Name)new X509Principal(encodedName));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid X500 name encoding");
        }
    }

    public static GeneralNames x500nameToGeneralNames(X500Principal name) {
        return Util.generalNameToGeneralNames(Util.x500nameToGeneralName(name.getEncoded()));
    }

    public static X500Principal generalNameToX500Name(GeneralName name) {
        int tag = -1;
        if (name == null || (tag = name.getTagNo()) != 4) {
            throw new IllegalArgumentException("GeneralName is not a DirectoryName (tag=" + tag + ")");
        }
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)b).writeObject((Object)name.getName());
            return new X500Principal(b.toByteArray());
        }
        catch (IOException i) {
            throw new IllegalArgumentException("Bad DN encoding of Attribute Certificate issuer");
        }
    }

    public static X509Principal generalNameToX509Name(GeneralName name) {
        int tag = -1;
        if (name == null || (tag = name.getTagNo()) != 4) {
            throw new IllegalArgumentException("GeneralName is not a DirectoryName (tag=" + tag + ")");
        }
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)b).writeObject((Object)name.getName());
            return new X509Principal(b.toByteArray());
        }
        catch (IOException i) {
            throw new IllegalArgumentException("Bad DN encoding of Attribute Certificate issuer");
        }
    }
}

