/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ObjectDigestInfo
implements DEREncodable {
    DEREnumerated digestedObjectType;
    DERObjectIdentifier otherObjectTypeID;
    AlgorithmIdentifier digestAlgorithm;
    DERBitString objectDigest;

    public ObjectDigestInfo(ASN1Sequence seq) {
        this.digestedObjectType = DEREnumerated.getInstance((Object)((DERTaggedObject)seq.getObjectAt(0)));
        int offset = 0;
        if (seq.size() == 4) {
            this.otherObjectTypeID = DERObjectIdentifier.getInstance((Object)seq.getObjectAt(1));
            ++offset;
        }
        this.digestAlgorithm = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1 + offset));
        this.objectDigest = new DERBitString(seq.getObjectAt(2 + offset));
    }

    public DEREnumerated getDigestedObjectType() {
        return this.digestedObjectType;
    }

    public DERObjectIdentifier getOtherObjectTypeID() {
        return this.otherObjectTypeID;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public DERBitString getObjectDigest() {
        return this.objectDigest;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.digestedObjectType);
        if (this.otherObjectTypeID != null) {
            v.add((DEREncodable)this.otherObjectTypeID);
        }
        v.add((DEREncodable)this.digestAlgorithm);
        v.add((DEREncodable)this.objectDigest);
        return new DERSequence(v);
    }
}

