/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.x509.GeneralNames;

public class IetfAttrSyntax
implements DEREncodable {
    public static final int VALUE_OCTETS = 1;
    public static final int VALUE_OID = 2;
    public static final int VALUE_UTF8 = 3;
    GeneralNames policyAuthority = null;
    Vector values = new Vector();
    int valueChoice = -1;

    public IetfAttrSyntax(ASN1Sequence seq) {
        int i = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.policyAuthority = GeneralNames.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(0)), (boolean)false);
            ++i;
        }
        if (!(seq.getObjectAt(i) instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Non-IetfAttrSyntax encoding");
        }
        seq = (ASN1Sequence)seq.getObjectAt(i);
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            int type;
            DERObject obj = (DERObject)e.nextElement();
            if (obj instanceof DERObjectIdentifier) {
                type = 2;
            } else if (obj instanceof DERUniversalString) {
                type = 3;
            } else if (obj instanceof DEROctetString) {
                type = 1;
            } else {
                throw new IllegalArgumentException("Bad value type encoding IetfAttrSyntax");
            }
            if (this.valueChoice < 0) {
                this.valueChoice = type;
            }
            if (type != this.valueChoice) {
                throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
            }
            this.values.add(obj);
        }
    }

    public GeneralNames getPolicyAuthority() {
        return this.policyAuthority;
    }

    public int getValueType() {
        return this.valueChoice;
    }

    public List getValues() {
        return this.values;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.policyAuthority != null) {
            v.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)this.policyAuthority));
        }
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        Iterator i = this.values.iterator();
        while (i.hasNext()) {
            v2.add((DEREncodable)i.next());
        }
        v.add((DEREncodable)new DERSequence(v2));
        return new DERSequence(v);
    }
}

