/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.glite.voms.ac.V2Form;

public class AttCertIssuer
implements DEREncodable {
    GeneralNames v1Form;
    V2Form v2Form;
    int version = -1;

    public AttCertIssuer(DEREncodable obj) {
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject cObj = (ASN1TaggedObject)obj;
            if (cObj.isExplicit() && cObj.getTagNo() == 0) {
                this.v2Form = new V2Form(ASN1Sequence.getInstance((ASN1TaggedObject)cObj, (boolean)false));
                this.version = 2;
            }
        } else if (obj instanceof ASN1Sequence) {
            this.v1Form = new GeneralNames((ASN1Sequence)obj);
            this.version = 1;
        }
        if (this.version < 0) {
            throw new IllegalArgumentException("AttCertIssuer: input not a proper CHOICE");
        }
    }

    public AttCertIssuer(V2Form v2FormIn) {
        this.v2Form = v2FormIn;
        this.version = 2;
    }

    public AttCertIssuer(GeneralNames v1FormIn) {
        this.v1Form = v1FormIn;
        this.version = 1;
    }

    public GeneralNames getIssuerName() {
        switch (this.version) {
            case 1: {
                return this.v1Form;
            }
            case 2: {
                return this.v2Form.getIssuerName();
            }
        }
        return null;
    }

    public DERObject getDERObject() {
        switch (this.version) {
            case 1: {
                return this.v1Form.getDERObject();
            }
            case 2: {
                return new DERTaggedObject(true, 0, (DEREncodable)this.v2Form);
            }
        }
        return null;
    }
}

