/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIStoreFactory;
import org.glite.voms.PKIVerifier;

public class VOMSTrustManager
implements X509TrustManager {
    private PKIStore store = null;
    private PKIVerifier verifier = null;
    boolean stopcalled = false;
    private static Logger logger = Logger.getLogger((String)VOMSTrustManager.class.getName());

    public VOMSTrustManager(String dir) throws IOException, CertificateException, CRLException {
        this.store = PKIStoreFactory.getStore(dir, 2);
        this.verifier = new PKIVerifier(null, this.store);
        this.stopcalled = false;
    }

    public VOMSTrustManager(PKIStore castore) throws IOException, CertificateException, CRLException {
        this.verifier = new PKIVerifier(null, castore);
        this.store = castore;
        this.stopcalled = false;
    }

    public synchronized void stop() {
        if (!this.stopcalled) {
            this.verifier.cleanup();
            this.stopcalled = true;
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || authType == null || chain.length == 0 || authType.length() == 0) {
            throw new IllegalArgumentException("One of the parameters is null or empty.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Callying verify:");
            logger.debug((Object)"chain is:");
            for (int i = 0; i < chain.length; ++i) {
                logger.debug((Object)("HAVE TO VERIFY: " + chain[i].getSubjectDN()));
            }
        }
        if (this.verifier.verify(chain)) {
            return;
        }
        throw new CertificateException("Cannot verify certificate.  See log for details.");
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkClientTrusted(chain, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        Hashtable CAs = this.store.getCAs();
        ArrayList certs = new ArrayList(CAs.size());
        Enumeration certVectors = CAs.elements();
        while (certVectors.hasMoreElements()) {
            Vector certVector = (Vector)certVectors.nextElement();
            certs.addAll(certVector);
        }
        X509Certificate[] array = new X509Certificate[certs.size()];
        return certs.toArray(array);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

