/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.glite.voms.contact.PathNamingScheme;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSRequestFragment;
import org.glite.voms.contact.VOMSRequestOptions;
import org.w3c.dom.Document;

public class VOMSRequestFactory {
    private static Logger log = Logger.getLogger(VOMSRequestFactory.class);
    private static VOMSRequestFactory instance = null;
    private String orderString;
    private String targetString;
    private long lifetime = 0L;
    protected DocumentBuilder docBuilder;

    public static VOMSRequestFactory instance() {
        if (instance == null) {
            instance = new VOMSRequestFactory();
        }
        return instance;
    }

    private VOMSRequestFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.fatal((Object)"Error configuring DOM document builder.");
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public String getOrderString() {
        return this.orderString;
    }

    public void setOrderString(String orderString) {
        this.orderString = orderString;
    }

    public String getTargetString() {
        return this.targetString;
    }

    public void setTargetString(String targetString) {
        this.targetString = targetString;
    }

    private void setOptionsForRequest(VOMSRequestFragment fragment) {
        if (this.orderString != null && this.orderString != "") {
            fragment.buildOrderElement(this.orderString);
        }
        if (this.targetString != null && this.targetString != "") {
            fragment.buildTargetsElement(this.targetString);
        }
        fragment.buildLifetime(this.lifetime);
    }

    private void loadOptions(VOMSRequestOptions options) {
        this.lifetime = options.getLifetime();
        this.setOrderString(options.getOrdering());
        this.setTargetString(options.getTargetsAsString());
    }

    public String buildRESTRequest(VOMSRequestOptions options) {
        this.loadOptions(options);
        if (options.isRequestList()) {
            return "/generate-ac?fqans=all";
        }
        StringBuilder request = new StringBuilder();
        request.append("/generate-ac?fqans=");
        if (options.getRequestedFQANs().isEmpty()) {
            if (options.getVoName() == null) {
                throw new VOMSException("No vo name specified for AC retrieval.");
            }
            String voName = options.getVoName();
            if (!voName.startsWith("/")) {
                voName = "/" + voName;
            }
            request.append(voName);
        } else {
            List FQANs = options.getRequestedFQANs();
            Iterator i = FQANs.iterator();
            boolean first = true;
            while (i.hasNext()) {
                if (!first) {
                    request.append(",");
                }
                request.append((String)i.next());
                first = false;
            }
        }
        if (this.targetString != null && this.targetString.trim().length() != 0) {
            request.append("&targets=");
            request.append(this.targetString);
        }
        if (this.orderString != null && this.orderString.trim().length() != 0) {
            request.append("&order=");
            request.append(this.orderString);
        }
        request.append("&lifetime=");
        request.append(this.lifetime);
        log.debug((Object)("Generated request: " + request.toString()));
        return request.toString();
    }

    public Document buildRequest(VOMSRequestOptions options) {
        this.loadOptions(options);
        Document request = this.docBuilder.newDocument();
        VOMSRequestFragment frag = new VOMSRequestFragment(request);
        if (options.isRequestList()) {
            frag.listCommand();
            this.setOptionsForRequest(frag);
            request.appendChild(frag.getFragment());
            return request;
        }
        if (options.getRequestedFQANs().isEmpty()) {
            if (options.getVoName() == null) {
                throw new VOMSException("No vo name specified for AC retrieval.");
            }
            String voName = options.getVoName();
            if (!voName.startsWith("/")) {
                voName = "/" + voName;
            }
            frag.groupCommand(voName);
            this.setOptionsForRequest(frag);
            request.appendChild(frag.getFragment());
            return request;
        }
        Iterator fqanIter = options.getRequestedFQANs().iterator();
        frag.buildBase64();
        frag.buildVersion();
        while (fqanIter.hasNext()) {
            String FQAN2 = (String)fqanIter.next();
            if (FQAN2.equals("all")) {
                frag.allCommand();
                continue;
            }
            if (PathNamingScheme.isGroup(FQAN2)) {
                frag.groupCommand(FQAN2);
                continue;
            }
            if (PathNamingScheme.isRole(FQAN2)) {
                frag.roleCommand(PathNamingScheme.getRoleName(FQAN2));
                continue;
            }
            if (!PathNamingScheme.isQualifiedRole(FQAN2)) continue;
            frag.mappingCommand(PathNamingScheme.getGroupName(FQAN2), PathNamingScheme.getRoleName(FQAN2));
        }
        this.setOptionsForRequest(frag);
        request.appendChild(frag.getFragment());
        return request;
    }
}

