/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class GenericAttribute
implements DEREncodable {
    private String name;
    private String value;
    private String qualifier;

    public GenericAttribute() {
        this.qualifier = null;
        this.value = null;
        this.name = null;
    }

    public GenericAttribute(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("Encoding error in GenericAttribute");
        }
        this.qualifier = null;
        this.value = null;
        this.name = null;
        if (!(seq.getObjectAt(0) instanceof ASN1OctetString && seq.getObjectAt(1) instanceof ASN1OctetString && seq.getObjectAt(2) instanceof ASN1OctetString)) {
            throw new IllegalArgumentException("Encoding error in GenericAttribute");
        }
        this.value = new String(DEROctetString.getInstance((Object)seq.getObjectAt(1)).getOctets());
        this.name = new String(DEROctetString.getInstance((Object)seq.getObjectAt(0)).getOctets());
        this.qualifier = new String(DEROctetString.getInstance((Object)seq.getObjectAt(2)).getOctets());
    }

    public static GenericAttribute getInstance(ASN1Sequence seq) {
        return new GenericAttribute(seq);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)new DEROctetString(this.name.getBytes()));
        v.add((DEREncodable)new DEROctetString(this.value.getBytes()));
        v.add((DEREncodable)new DEROctetString(this.qualifier.getBytes()));
        return new DERSequence(v);
    }
}

