/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.glite.voms.FQAN;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttCertIssuer;
import org.glite.voms.ac.FullAttributes;
import org.glite.voms.ac.Holder;
import org.glite.voms.ac.IetfAttrSyntax;

public class AttributeCertificateInfo
implements DEREncodable {
    DERInteger version;
    Holder holder;
    AttCertIssuer issuer;
    AlgorithmIdentifier signature;
    DERInteger serialNumber;
    AttCertValidityPeriod attrCertValidityPeriod;
    ASN1Sequence attributes;
    DERBitString issuerUniqueID;
    X509Extensions extensions;
    boolean badVomsEncoding = false;
    FullAttributes fullAttributes = null;
    ACTargets acTargets = null;
    ACCerts acCerts = null;
    private String myVo = null;
    private String myHostPort = null;
    private Vector myStringList = new Vector();
    private Vector myFQANs = new Vector();
    private String myHost = null;
    private int myPort = -1;
    public static final String AC_TARGET_OID = "2.5.29.55";
    public static final String AC_CERTS_OID = "1.3.6.1.4.1.8005.100.100.10";
    public static final String AC_FULL_ATTRIBUTES_OID = "1.3.6.1.4.1.8005.100.100.11";
    public static final String VOMS_EXT_OID = "1.3.6.1.4.1.8005.100.100.5";
    public static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";

    public AttributeCertificateInfo(ASN1Sequence seq) {
        byte[] data;
        ASN1Sequence s2;
        DERObjectIdentifier AC_TARGET_OID_DER = new DERObjectIdentifier(AC_TARGET_OID);
        DERObjectIdentifier AC_CERTS_OID_DER = new DERObjectIdentifier(AC_CERTS_OID);
        DERObjectIdentifier AC_FULL_ATTRIBUTES_OID_DER = new DERObjectIdentifier(AC_FULL_ATTRIBUTES_OID);
        this.version = (DERInteger)seq.getObjectAt(0);
        this.holder = new Holder((ASN1Sequence)seq.getObjectAt(1));
        this.issuer = new AttCertIssuer(seq.getObjectAt(2));
        this.signature = new AlgorithmIdentifier((ASN1Sequence)seq.getObjectAt(3));
        this.serialNumber = (DERInteger)seq.getObjectAt(4);
        ASN1Sequence s3 = s2 = (ASN1Sequence)seq.getObjectAt(5);
        if (s2.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.badVomsEncoding = true;
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < 2; ++i) {
                byte[] bb = ((DEROctetString)((ASN1TaggedObject)s2.getObjectAt(i)).getObject()).getOctets();
                v.add((DEREncodable)new DERGeneralizedTime(new String(bb)));
            }
            s3 = new DERSequence(v);
        }
        this.attrCertValidityPeriod = new AttCertValidityPeriod(s3);
        this.attributes = (ASN1Sequence)seq.getObjectAt(6);
        if (this.attributes != null && this.attributes.size() != 0) {
            Enumeration e = this.attributes.getObjects();
            while (e.hasMoreElements()) {
                ASN1Sequence attribute = (ASN1Sequence)e.nextElement();
                if (!VOMS_ATTR_OID.equals(((DERObjectIdentifier)attribute.getObjectAt(0)).getId())) continue;
                DERSet set = (DERSet)attribute.getObjectAt(1);
                Enumeration s = set.getObjects();
                while (s.hasMoreElements()) {
                    IetfAttrSyntax attr = new IetfAttrSyntax((ASN1Sequence)s.nextElement());
                    String url = ((DERIA5String)GeneralName.getInstance((Object)((ASN1Sequence)attr.getPolicyAuthority().getDERObject()).getObjectAt(0)).getName()).getString();
                    int idx = url.indexOf("://");
                    if (idx < 0 || idx == url.length() - 1) {
                        throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + url + "]");
                    }
                    this.myVo = url.substring(0, idx);
                    this.myHostPort = url.substring(idx + 3);
                    idx = this.myHostPort.lastIndexOf(58);
                    if (idx < 0 || idx == this.myHostPort.length() - 1) {
                        throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + url + "]");
                    }
                    this.myHost = this.myHostPort.substring(0, idx);
                    this.myPort = Integer.parseInt(this.myHostPort.substring(idx + 1));
                    if (attr.getValueType() != 1) {
                        throw new IllegalArgumentException("VOMS attribute values are not encoded as octet strings, policyAuthority = " + url);
                    }
                    Iterator j = attr.getValues().iterator();
                    while (j.hasNext()) {
                        String fqan = new String(((ASN1OctetString)j.next()).getOctets());
                        FQAN f = new FQAN(fqan);
                        if (this.myStringList.contains(fqan) || !fqan.startsWith("/" + this.myVo + "/") && !fqan.equals("/" + this.myVo)) continue;
                        this.myStringList.add(fqan);
                        this.myFQANs.add(f);
                    }
                }
            }
        }
        if (seq.size() > 8) {
            this.issuerUniqueID = new DERBitString(seq.getObjectAt(7));
            this.extensions = new X509Extensions((ASN1Sequence)seq.getObjectAt(8));
        } else if (seq.size() > 7) {
            this.extensions = new X509Extensions((ASN1Sequence)seq.getObjectAt(7));
        }
        if (this.extensions.getExtension(AC_TARGET_OID_DER) != null) {
            data = this.extensions.getExtension(AC_TARGET_OID_DER).getValue().getOctets();
            DERObject dobj = null;
            try {
                dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(data)).readObject();
                this.acTargets = new ACTargets(ASN1Sequence.getInstance((Object)dobj));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("DERO: " + e.getMessage());
            }
        }
        if (this.extensions.getExtension(AC_CERTS_OID_DER) != null) {
            data = this.extensions.getExtension(AC_CERTS_OID_DER).getValue().getOctets();
            DERObject dobj = null;
            try {
                dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(data)).readObject();
                this.acCerts = new ACCerts(ASN1Sequence.getInstance((Object)dobj));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("DERO: " + e.getMessage());
            }
        }
        if (this.extensions.getExtension(AC_FULL_ATTRIBUTES_OID_DER) != null) {
            data = this.extensions.getExtension(AC_FULL_ATTRIBUTES_OID_DER).getValue().getOctets();
            DERObject dobj = null;
            try {
                dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(data)).readObject();
                this.fullAttributes = new FullAttributes(ASN1Sequence.getInstance((Object)dobj));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("DERO: " + e.getMessage());
            }
        }
    }

    public static AttributeCertificateInfo getInstance(ASN1Sequence seq) {
        return new AttributeCertificateInfo(seq);
    }

    public DERInteger getAttCertVersion() {
        return this.version;
    }

    public Holder getHolder() {
        return this.holder;
    }

    public AttCertIssuer getIssuer() {
        return this.issuer;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.attrCertValidityPeriod;
    }

    public ASN1Sequence getAttributes() {
        return this.attributes;
    }

    public String getVO() {
        return this.myVo;
    }

    public String getHostPort() {
        return this.myHostPort;
    }

    public String getHost() {
        return this.myHost;
    }

    public int getPort() {
        return this.myPort;
    }

    public DERBitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public FullAttributes getFullAttributes() {
        return this.fullAttributes;
    }

    public ACCerts getCertList() {
        return this.acCerts;
    }

    public ACTargets getTargets() {
        return this.acTargets;
    }

    public List getFullyQualifiedAttributes() {
        return this.myStringList;
    }

    public List getListOfFQAN() {
        return this.myFQANs;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.version);
        v.add((DEREncodable)this.holder);
        v.add((DEREncodable)this.issuer);
        v.add((DEREncodable)this.signature);
        v.add((DEREncodable)this.serialNumber);
        if (!this.badVomsEncoding) {
            v.add((DEREncodable)this.attrCertValidityPeriod);
        } else {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)new DEROctetString((this.attrCertValidityPeriod.getNotBeforeTime().getTime().substring(0, 14) + "Z").getBytes())));
            v2.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)new DEROctetString((this.attrCertValidityPeriod.getNotAfterTime().getTime().substring(0, 14) + "Z").getBytes())));
            v.add((DEREncodable)new DERSequence(v2));
        }
        v.add((DEREncodable)this.attributes);
        if (this.issuerUniqueID != null) {
            v.add((DEREncodable)this.issuerUniqueID);
        }
        if (this.extensions != null) {
            v.add((DEREncodable)this.extensions);
        }
        return new DERSequence(v);
    }
}

