/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;

public class ACCerts
implements DEREncodable {
    List l = new Vector();

    public ACCerts() {
    }

    public ACCerts(ASN1Sequence seq) {
        seq = (ASN1Sequence)seq.getObjectAt(0);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            throw new ExceptionInInitializerError("Cannot find BouncyCastle provider: " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new ExceptionInInitializerError("X.509 Certificates unsupported. " + e.getMessage());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error in setting up ACCerts reader. " + ex.getMessage());
        }
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof DERSequence) {
                ASN1Sequence s = ASN1Sequence.getInstance(o);
                byte[] data = null;
                try {
                    data = new X509CertificateObject(X509CertificateStructure.getInstance((Object)s)).getEncoded();
                    this.l.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data)));
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Error in encoding ACCerts. " + ex.getMessage());
                }
            }
            throw new IllegalArgumentException("Incorrect encoding for ACCerts");
        }
    }

    public static ACCerts getInstance(ASN1Sequence seq) {
        return new ACCerts(seq);
    }

    public void addCert(X509CertificateStructure cert) {
        this.l.add(cert);
    }

    public List getCerts() {
        return this.l;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        ListIterator li = this.l.listIterator();
        while (li.hasNext()) {
            X509CertificateStructure x509 = (X509CertificateStructure)li.next();
            v.add((DEREncodable)x509);
        }
        return new DERSequence(v);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

