/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.LSCFile;
import org.glite.voms.MyDERInputStream;
import org.glite.voms.Namespace;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIStoreFactory;
import org.glite.voms.PKIUtils;
import org.glite.voms.SigningPolicy;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.AttributeCertificateInfo;
import org.glite.voms.ac.VOMSTrustStore;
import org.glite.voms.contact.MyProxyCertInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIVerifier {
    private static Logger logger = Logger.getLogger((String)PKIVerifier.class.getName());
    public static final String SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    public static final String AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    public static final String PROXYCERTINFO = "1.3.6.1.5.5.7.1.14";
    public static final String PROXYCERTINFO_OLD = "1.3.6.1.4.1.3536.1.222";
    public static final String BASIC_CONSTRAINTS_IDENTIFIER = "2.5.29.19";
    public static final String KEY_USAGE_IDENTIFIER = "2.5.29.15";
    public static final String TARGET = "2.5.29.55";
    private static final String[] OIDs = new String[]{"2.5.29.14", "2.5.29.35", "1.3.6.1.5.5.7.1.14", "1.3.6.1.4.1.3536.1.222", "2.5.29.19", "2.5.29.15"};
    private static final String[] AC_OIDs = new String[]{"2.5.29.55"};
    private static final Set handledOIDs = new TreeSet<String>(Arrays.asList(OIDs));
    private static final Set handledACOIDs = new TreeSet<String>(Arrays.asList(AC_OIDs));
    private PKIStore caStore = null;
    private VOMSTrustStore vomsStore = null;

    public PKIVerifier(VOMSTrustStore vomsStore, PKIStore caStore) {
        this.vomsStore = vomsStore;
        this.caStore = caStore;
    }

    public PKIVerifier(VOMSTrustStore vomsStore) throws IOException, CertificateException, CRLException {
        this.vomsStore = vomsStore;
        this.caStore = PKIStoreFactory.getStore(2);
    }

    public PKIVerifier() throws IOException, CertificateException, CRLException {
        this.vomsStore = PKIStoreFactory.getStore(1);
        this.caStore = PKIStoreFactory.getStore(2);
    }

    public void cleanup() {
        if (this.vomsStore != null) {
            this.vomsStore.stopRefresh();
        }
        if (this.caStore != null) {
            this.caStore.stopRefresh();
        }
        this.vomsStore = null;
        this.caStore = null;
    }

    public void setCAStore(PKIStore store) {
        if (this.caStore != null) {
            this.caStore.stopRefresh();
            this.caStore = null;
        }
        this.caStore = store;
    }

    public void setVOMSStore(VOMSTrustStore store) {
        if (this.vomsStore != null) {
            this.vomsStore.stopRefresh();
            this.vomsStore = null;
        }
        this.vomsStore = store;
    }

    private static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            logger.error((Object)"Cannot discover hostName.");
            return "";
        }
    }

    public boolean verify(AttributeCertificate ac) {
        X509Extensions exts;
        if (ac == null || this.vomsStore == null) {
            return false;
        }
        AttributeCertificateInfo aci = ac.getAcinfo();
        X509Certificate[] certificates = null;
        ACCerts certList = aci.getCertList();
        LSCFile lsc = null;
        String voName = ac.getVO();
        if (certList != null) {
            lsc = this.vomsStore.getLSC(voName, ac.getHost());
        }
        logger.debug((Object)("LSC is: " + lsc));
        if (lsc != null) {
            boolean success = false;
            Vector dns = lsc.getDNLists();
            Iterator dnIter = dns.iterator();
            while (!success && dnIter.hasNext()) {
                boolean doBreak = false;
                while (dnIter.hasNext() && !doBreak) {
                    Iterator certIter = certList.getCerts().iterator();
                    Vector realDNs = (Vector)dnIter.next();
                    Iterator realDNsIter = realDNs.iterator();
                    while (realDNsIter.hasNext() && certIter.hasNext() && !doBreak) {
                        String dn = null;
                        String is = null;
                        try {
                            dn = (String)realDNsIter.next();
                            is = (String)realDNsIter.next();
                        }
                        catch (NoSuchElementException e) {
                            doBreak = true;
                        }
                        X509Certificate cert = (X509Certificate)certIter.next();
                        String candidateDN = PKIUtils.getOpenSSLFormatPrincipal(cert.getSubjectDN());
                        String candidateIs = PKIUtils.getOpenSSLFormatPrincipal(cert.getIssuerDN());
                        logger.debug((Object)("canddn is : " + candidateDN));
                        logger.debug((Object)("candis is : " + candidateIs));
                        if (dn != null) {
                            logger.debug((Object)("dn is : " + dn));
                            logger.debug((Object)("dn == canddn is " + dn.equals(candidateDN)));
                        }
                        if (is != null) {
                            logger.debug((Object)("is is : " + is));
                            logger.debug((Object)("is == candis is " + is.equals(candidateIs)));
                        }
                        if (dn == null || is == null || dn.equals(candidateDN) && is.equals(candidateIs)) continue;
                        doBreak = true;
                    }
                    if (doBreak || realDNsIter.hasNext() || certIter.hasNext()) continue;
                    success = true;
                }
            }
            if (success) {
                logger.debug((Object)"LSC Verification step.");
                certificates = certList.getCerts().toArray(new X509Certificate[0]);
                if (!ac.verifyCert(certificates[0])) {
                    certificates = null;
                    logger.debug((Object)"Signature Verification false (from LSC).");
                } else {
                    logger.debug((Object)"Signature Verification OK (from LSC).");
                }
            }
        }
        if (certificates == null) {
            X509Certificate[] candidates;
            logger.debug((Object)"lsc check failed.");
            if (logger.isDebugEnabled()) {
                X500Principal issuer = ac.getIssuer();
                logger.debug((Object)("Looking for hash: " + PKIUtils.getHash(issuer) + " for certificate: " + issuer.getName()));
            }
            if ((candidates = this.vomsStore.getAACandidate(ac.getIssuer(), voName)) == null) {
                logger.debug((Object)"No candidates found!");
            } else if (candidates.length != 0) {
                for (int i = 0; i < candidates.length; ++i) {
                    X509Certificate currentCert = candidates[i];
                    PublicKey key = currentCert.getPublicKey();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Candidate: " + currentCert.getSubjectDN().getName()));
                        logger.debug((Object)("Key class: " + key.getClass()));
                        logger.debug((Object)("Key: " + key));
                        byte[] data = key.getEncoded();
                        StringBuffer str = new StringBuffer();
                        str.append("Key: ");
                        for (int j = 0; j < data.length; ++j) {
                            str.append(Integer.toHexString(data[j]));
                            str.append(' ');
                        }
                        logger.debug((Object)str.toString());
                    }
                    if (ac.verifyCert(currentCert)) {
                        logger.debug((Object)"Signature Verification OK");
                        certificates = new X509Certificate[]{currentCert};
                        break;
                    }
                    logger.debug((Object)"Signature Verification false");
                }
            }
        }
        if (certificates == null) {
            logger.error((Object)"Cannot find usable certificates to validate the AC. Check that the voms server host certificate is in your vomsdir directory.");
            return false;
        }
        if (logger.isDebugEnabled()) {
            for (int l = 0; l < certificates.length; ++l) {
                logger.debug((Object)("Position: " + l + " value: " + certificates[l].getSubjectDN().getName()));
            }
        }
        if (!this.verify(certificates)) {
            logger.error((Object)"Cannot verify issuer certificate chain for AC");
            return false;
        }
        if (!ac.isValid()) {
            logger.error((Object)"Attribute Certificate not valid at current time.");
            return false;
        }
        ACTargets targets = aci.getTargets();
        if (targets != null) {
            String hostname = PKIVerifier.getHostName();
            boolean success = false;
            for (String name : targets.getTargets()) {
                if (!name.equals(hostname)) continue;
                success = true;
                break;
            }
            if (!success) {
                logger.error((Object)"Targeting check failed!");
                return false;
            }
        }
        if ((exts = aci.getExtensions()) != null) {
            Enumeration oids = exts.oids();
            while (oids.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)oids.nextElement();
                X509Extension ext = exts.getExtension(oid);
                if (!ext.isCritical() || handledACOIDs.contains(oid)) continue;
                logger.error((Object)("Unknown critical extension discovered: " + oid.getId()));
                return false;
            }
        }
        return true;
    }

    private boolean checkProxyCertInfo(X509Certificate cert, int posInChain, int chainSize) {
        X509Extension ext = null;
        byte[] payload = cert.getExtensionValue(PROXYCERTINFO);
        if (payload == null) {
            payload = cert.getExtensionValue(PROXYCERTINFO_OLD);
            if (payload == null) {
                logger.debug((Object)"No ProxyCertInfo extension found.");
                return true;
            }
            ext = new X509Extension(false, (ASN1OctetString)new DEROctetString(payload));
        } else {
            ext = new X509Extension(true, (ASN1OctetString)new DEROctetString(payload));
        }
        DERObject obj = null;
        try {
            obj = new ASN1InputStream((InputStream)new ByteArrayInputStream(ext.getValue().getOctets())).readObject();
            MyDERInputStream str = new MyDERInputStream(((DEROctetString)obj).getOctetStream());
            int len = 0;
            int res = 0;
            str.read();
            len = str.readLength();
            res = str.read(payload, 0, len);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read DERObject from source data:" + e.getMessage());
        }
        MyProxyCertInfo pci = new MyProxyCertInfo(payload);
        if (pci.getPathLenConstraint() != -1 && pci.getPathLenConstraint() < chainSize - posInChain) {
            logger.error((Object)"ProxyCertInfo pathlen constraint violation.");
            if (logger.isDebugEnabled()) {
                String debugString = String.format("pathLenConstraint: %d, certificateChainSize: %d, positionInChain: %d", pci.getPathLenConstraint(), chainSize, posInChain);
                logger.debug((Object)debugString);
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(X509Certificate[] certs) {
        X509Certificate candidate2;
        X509Certificate currentCert;
        int proxyCount;
        Stack<X509Certificate> certStack;
        block35: {
            Vector candidates;
            String hash;
            if (this.caStore == null) {
                logger.error((Object)"No Trust Anchor are known.");
                return false;
            }
            if (certs.length <= 0) {
                logger.error((Object)"Certificate verification: passed empty certificate array.");
                return false;
            }
            Hashtable certificates = this.caStore.getCAs();
            certStack = new Stack<X509Certificate>();
            proxyCount = 0;
            certStack.push(certs[0]);
            logger.debug((Object)("Starting certificate verification for '" + certs[0].getSubjectDN().getName() + "'"));
            currentCert = certs[0];
            for (int i = 1; i < certs.length; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Checking: " + certs[i].getSubjectDN().getName()));
                }
                if (!PKIUtils.checkIssued(certs[i], certs[i - 1])) continue;
                if (PKIUtils.isProxy(currentCert)) {
                    ++proxyCount;
                }
                certStack.push(certs[i]);
                currentCert = certs[i];
            }
            candidate2 = null;
            if (PKIUtils.selfIssued(currentCert)) {
                hash = PKIUtils.getHash(currentCert);
                candidates = (Vector)certificates.get(hash);
                int index = -1;
                if (candidates != null && (index = candidates.indexOf(currentCert)) != -1) {
                    certStack.pop();
                    candidate2 = (X509Certificate)candidates.elementAt(index);
                    certStack.push(candidate2);
                    break block35;
                } else {
                    logger.error((Object)("Cannot find issuer candidate for: " + currentCert.getSubjectDN().getName()));
                    return false;
                }
            }
            candidate2 = null;
            block6: do {
                hash = PKIUtils.getHash(currentCert.getIssuerX500Principal());
                logger.debug((Object)("Issuer principal hash = " + hash));
                candidates = (Vector)certificates.get(hash);
                if (candidates == null) continue;
                logger.debug((Object)("Candidates trust anchors from store: " + candidates));
                for (X509Certificate candidate2 : candidates) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Candidate trust anchor subject = " + candidate2.getSubjectDN().getName()));
                    }
                    if (PKIUtils.checkIssued(candidate2, currentCert)) {
                        certStack.push(candidate2);
                        currentCert = candidate2;
                        continue block6;
                    }
                    candidate2 = null;
                }
            } while (candidate2 != null && !PKIUtils.selfIssued(currentCert));
        }
        if (candidate2 == null) {
            logger.error((Object)"Certificate verification: no trust anchor found.");
            return false;
        }
        int currentLength = 0;
        PublicKey candidatePublicKey = null;
        X509Certificate issuerCert = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Constructed certificate chain:");
            Iterator j = certStack.iterator();
            int chainIndex = 0;
            while (j.hasNext()) {
                logger.debug((Object)("[" + chainIndex + "]: " + ((X509Certificate)j.next()).getSubjectDN().getName()));
            }
        }
        int stackSize = certStack.size();
        int stackPos = stackSize + 1;
        Stack<X509Certificate> constructedStack = new Stack<X509Certificate>();
        int certCount = 0;
        while (!certStack.isEmpty()) {
            Set<String> criticals;
            currentCert = (X509Certificate)certStack.pop();
            --stackPos;
            if (!PKIUtils.isProxy(currentCert)) {
                ++certCount;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking : " + currentCert.getSubjectDN().getName()));
            }
            if (!this.checkProxyCertInfo(currentCert, stackPos, stackSize)) {
                logger.error((Object)"ProxyCertInfo extension violated.");
                return false;
            }
            if (PKIUtils.selfIssued(currentCert)) {
                if (currentLength != 0) {
                    logger.error((Object)("Certificate verification: Self signed certificate not trust anchor: " + currentCert.getSubjectDN().getName()));
                    return false;
                }
                candidatePublicKey = currentCert.getPublicKey();
                issuerCert = currentCert;
            }
            if (!currentCert.getIssuerX500Principal().equals(issuerCert.getSubjectX500Principal())) {
                logger.error((Object)"Certificate verification: issuing chain broken.");
                return false;
            }
            try {
                currentCert.checkValidity();
            }
            catch (CertificateExpiredException e) {
                logger.error((Object)("Certificate verification: certificate in chain expired. " + e.getMessage()), (Throwable)e);
                logger.error((Object)("Faulty certificate: " + currentCert.getSubjectDN().getName()));
                logger.error((Object)("End validity      : " + currentCert.getNotAfter().toString()));
                return false;
            }
            catch (CertificateNotYetValidException e) {
                logger.error((Object)("Certificate verification: certificate in chain not yet valid. " + e.getMessage()), (Throwable)e);
                logger.error((Object)("Faulty certificate: " + currentCert.getSubjectDN().getName()));
                logger.error((Object)("Start validity      : " + currentCert.getNotBefore().toString()));
                return false;
            }
            try {
                currentCert.verify(candidatePublicKey);
            }
            catch (Exception e) {
                logger.error((Object)("Certificate verification: cannot verify signature. " + e.getMessage()), (Throwable)e);
                logger.error((Object)("Faulty certificate: " + currentCert.getSubjectDN().getName()));
                return false;
            }
            if (this.isRevoked(currentCert, issuerCert)) {
                logger.error((Object)"Certificate verification: certificate in chain has been revoked.");
                logger.error((Object)("Faulty certificate: " + currentCert.getSubjectDN().getName()));
                return false;
            }
            boolean isCA = PKIUtils.isCA(issuerCert);
            if (isCA) {
                if (!this.allowsPath(currentCert, issuerCert, constructedStack)) {
                    logger.error((Object)("Certificate verification: subject '" + currentCert.getSubjectDN().getName() + "' not allowed by CA '" + issuerCert.getSubjectDN().getName() + "'"));
                    return false;
                }
                int maxPath = currentCert.getBasicConstraints();
                if (maxPath != -1 && maxPath < certStack.size() - proxyCount - 1) {
                    logger.error((Object)"Certificate verification: Maximum certification path length exceeded.");
                    return false;
                }
            } else if (!PKIUtils.isProxy(currentCert)) {
                logger.error((Object)"Certificate verification: Non-proxy, non-CA certificate issued a certificate.");
                return false;
            }
            if ((criticals = currentCert.getCriticalExtensionOIDs()) != null && !handledOIDs.containsAll(criticals)) {
                logger.error((Object)"Certificate verification: Certificate contain unhandled critical extensions.");
                return false;
            }
            issuerCert = currentCert;
            candidatePublicKey = currentCert.getPublicKey();
            ++currentLength;
            constructedStack.push(currentCert);
        }
        return true;
    }

    private boolean allowsNamespaces(X509Certificate cert, X509Certificate issuer, Stack certStack) {
        if (PKIUtils.selfIssued(cert)) {
            return true;
        }
        Hashtable namespaces = this.caStore.getNamespaces();
        Namespace namespaceCandidate = (Namespace)namespaces.get(PKIUtils.getHash(issuer));
        if (namespaceCandidate == null) {
            int size = certStack.size();
            int current = size - 1;
            logger.debug((Object)("size = " + size + ", current = " + current + "\n"));
            if (size > 0) {
                while ((namespaceCandidate = (Namespace)namespaces.get(PKIUtils.getHash((X509Certificate)certStack.elementAt(current)))) == null && --current != -1) {
                }
            }
            if (namespaceCandidate == null) {
                return true;
            }
        }
        int index = namespaceCandidate.findIssuer(issuer);
        while (index != -1) {
            logger.debug((Object)"looking inside namespace");
            namespaceCandidate.setCurrent(index);
            String subject = namespaceCandidate.getSubject();
            boolean permit = namespaceCandidate.getPermit();
            String currentSubj = PKIUtils.getOpenSSLFormatPrincipal(issuer.getSubjectDN());
            String currentSubjReversed = PKIUtils.getOpenSSLFormatPrincipal(issuer.getSubjectDN(), true);
            if (subject.equals(currentSubj) || subject.equals(currentSubjReversed)) {
                return permit;
            }
            index = namespaceCandidate.findIssuer(issuer, index);
        }
        return false;
    }

    private boolean allowsPath(X509Certificate cert, X509Certificate issuer, Stack certStack) {
        if (PKIUtils.selfIssued(cert)) {
            return true;
        }
        Hashtable signings = this.caStore.getSignings();
        SigningPolicy signCandidate = (SigningPolicy)signings.get(PKIUtils.getHash(issuer));
        logger.debug((Object)("signCandidate is: " + signCandidate));
        boolean matched = false;
        if (signCandidate == null) {
            return this.allowsNamespaces(cert, issuer, certStack);
        }
        if (signCandidate != null) {
            logger.debug((Object)("Class of issuer is : " + issuer.getClass()));
            logger.debug((Object)("Class of Subject is: " + issuer.getSubjectDN().getClass()));
            String issuerSubj = PKIUtils.getOpenSSLFormatPrincipal(issuer.getSubjectDN());
            logger.debug((Object)("Subject is : " + issuerSubj));
            Vector nameVector = this.getAllNames(cert);
            if (nameVector == null) {
                return false;
            }
            logger.debug((Object)("Content of Vector is:" + nameVector));
            for (String certSubj : nameVector) {
                logger.debug((Object)("Examining: " + certSubj));
                logger.debug((Object)("Looking for " + issuerSubj));
                int index = signCandidate.findIssuer(issuerSubj);
                if (index == -1) {
                    issuerSubj = PKIUtils.getOpenSSLFormatPrincipal(issuer.getSubjectDN(), true);
                    index = signCandidate.findIssuer(issuerSubj);
                }
                while (index != -1) {
                    logger.debug((Object)"Inside index");
                    signCandidate.setCurrent(index);
                    if (signCandidate.getAccessIDCA().equals(issuerSubj)) {
                        Vector subjects = signCandidate.getCondSubjects();
                        for (String subj : subjects) {
                            logger.debug((Object)("Comparing certSubj: '" + certSubj + "' to '" + subj + "'"));
                            subj = subj.replaceFirst("\\*", "\\.\\*");
                            if (certSubj.toUpperCase().matches(subj.toUpperCase())) {
                                matched = true;
                                logger.debug((Object)("Subject: '" + certSubj + "' matches with subject: '" + subj + "' from signing policy."));
                                break;
                            }
                            logger.debug((Object)("Subject: '" + certSubj + "' does not match subject: '" + subj + "' from signing policy."));
                        }
                    }
                    index = signCandidate.findIssuer(issuerSubj, index);
                }
                if (!matched) continue;
                logger.debug((Object)"MATCHED AT LEAST ONCE");
                break;
            }
            nameVector.clear();
        }
        logger.debug((Object)("Value of Matched is: " + matched));
        return matched;
    }

    private Vector getAllNames(X509Certificate cert) {
        if (cert != null) {
            Vector<String> v = new Vector<String>();
            v.add(PKIUtils.getOpenSSLFormatPrincipal(cert.getSubjectDN()));
            v.add(PKIUtils.getOpenSSLFormatPrincipal(cert.getSubjectDN(), true));
            return v;
        }
        return null;
    }

    private boolean checkCRLIssuer(X509CRL crl, X509Certificate issuer) {
        return crl.getIssuerX500Principal().equals(issuer.getSubjectX500Principal());
    }

    private boolean checkCRLCriticalExtensions(X509CRL crl) {
        Set<String> criticalExts = crl.getCriticalExtensionOIDs();
        HashSet<String> permittedCriticals = new HashSet<String>();
        permittedCriticals.add("2.5.29.28");
        if (criticalExts == null || criticalExts.isEmpty()) {
            return true;
        }
        if (!criticalExts.isEmpty() && !criticalExts.containsAll(permittedCriticals)) {
            logger.error((Object)("CRL critical extensions check failed for CRL " + crl.getIssuerX500Principal() + ". Critical extensions " + permittedCriticals + " not found!"));
            return false;
        }
        return true;
    }

    private boolean checkCRLValidity(X509CRL crl) {
        Date now = new Date();
        return crl.getNextUpdate().after(now) && crl.getThisUpdate().before(now);
    }

    private List<X509CRL> lookupCRL(X509Certificate issuer) {
        Hashtable crlMap = this.caStore.getCRLs();
        List crlList = (List)crlMap.get(PKIUtils.getHash(issuer));
        ArrayList<X509CRL> correctCrls = new ArrayList<X509CRL>();
        if (crlList == null || crlList.isEmpty()) {
            return null;
        }
        for (X509CRL candidateCRL : crlList) {
            try {
                candidateCRL.verify(issuer.getPublicKey());
            }
            catch (Exception e) {
                logger.info((Object)("Signature verification check failed for CRL " + candidateCRL.getIssuerX500Principal() + "..."));
                continue;
            }
            boolean criticalExtensionsAreValid = this.checkCRLCriticalExtensions(candidateCRL);
            if (!criticalExtensionsAreValid) {
                logger.info((Object)("Critical extensions check failed for CRL " + candidateCRL.getIssuerX500Principal() + "..."));
                continue;
            }
            if (!this.checkCRLIssuer(candidateCRL, issuer)) {
                logger.info((Object)String.format("Issuer check failed for CRL %s against issuer %s.", candidateCRL.getIssuerX500Principal(), issuer.getSubjectX500Principal()));
                continue;
            }
            correctCrls.add(candidateCRL);
        }
        return correctCrls;
    }

    private boolean isRevoked(X509Certificate cert, X509Certificate issuer) {
        logger.debug((Object)("Checking if '" + cert.getSubjectDN() + "' issued by '" + issuer.getSubjectDN() + "' has been revoked."));
        if (!PKIUtils.isCA(issuer)) {
            logger.debug((Object)("Issuer certificate '" + issuer.getSubjectDN() + "' is not a CA, so it cannot issue CRLs"));
            return false;
        }
        List<X509CRL> crls = this.lookupCRL(issuer);
        if (crls == null) {
            logger.warn((Object)("No CRL for CA '" + issuer.getSubjectDN() + "' was found in local trust-anchor dir. Considering certificate '" + cert.getSubjectDN() + "' valid."));
            return false;
        }
        if (crls.isEmpty()) {
            logger.warn((Object)("CRLs for CA '" + issuer.getSubjectDN() + "' was found but was ill-formed. Considering the certificate '" + cert.getSubjectDN() + "' revoked."));
            return true;
        }
        X509CRL validCrl = null;
        for (X509CRL crl : crls) {
            logger.debug((Object)("Checking CRL: " + crl));
            boolean crlIsValid = this.checkCRLValidity(crl);
            logger.debug((Object)("CRL is valid? " + crlIsValid));
            if (crlIsValid) {
                validCrl = crl;
                break;
            }
            String msg = String.format("CRL for CA '%s' has expired on %s.", issuer.getSubjectDN(), crl.getNextUpdate());
            logger.error((Object)msg);
        }
        if (validCrl == null) {
            logger.warn((Object)(" No temporally valid CRL for CA '" + issuer.getSubjectDN() + "' was found. Considering the certificate '" + cert.getSubjectDN() + "' revoked."));
            return true;
        }
        X509CRLEntry entry = validCrl.getRevokedCertificate(cert.getSerialNumber());
        logger.debug((Object)("CRLEntry for certificate serial number " + cert.getSerialNumber() + ": " + entry));
        if (entry == null) {
            return false;
        }
        logger.info((Object)String.format("Certificate %s (%d) was revoked on date %s.", cert.getSubjectDN(), entry.getSerialNumber(), entry.getRevocationDate()));
        return true;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

