/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https.impl;

import javax.net.ssl.SSLContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.italiangrid.utils.https.JettySSLConnectorConfigurator;
import org.italiangrid.utils.https.SSLOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextConnectorConfigurator
implements JettySSLConnectorConfigurator {
    public static final Logger log = LoggerFactory.getLogger(SSLContextConnectorConfigurator.class);
    protected SSLContext sslContext;

    public SSLContextConnectorConfigurator(SSLContext ctxt) {
        this.sslContext = ctxt;
    }

    @Override
    public Connector configureConnector(String host, int port, SSLOptions options) {
        if (this.sslContext == null) {
            log.error("Cannot initialize SSL out of a null SSL context!");
            return null;
        }
        try {
            SslContextFactory factory = new SslContextFactory();
            factory.setSslContext(this.sslContext);
            factory.setWantClientAuth(options.isWantClientAuth());
            factory.setNeedClientAuth(options.isNeedClientAuth());
            SslSelectChannelConnector connector = new SslSelectChannelConnector(factory);
            connector.setHost(host);
            connector.setPort(port);
            return connector;
        }
        catch (Throwable t) {
            log.error("SSL initialization error!", t);
            return null;
        }
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }
}

