/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.common.impl.AbstractSignableSAMLObject;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.ContactPerson;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.AttributeMap;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.XMLObjectChildrenList;

public abstract class RoleDescriptorImpl
extends AbstractSignableSAMLObject
implements RoleDescriptor {
    private String id;
    private DateTime validUntil;
    private Long cacheDuration;
    private final List<String> supportedProtocols;
    private String errorURL;
    private Extensions extensions;
    private Organization organization;
    private final AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);
    private final XMLObjectChildrenList<ContactPerson> contactPersons;
    private final XMLObjectChildrenList<KeyDescriptor> keyDescriptors;

    protected RoleDescriptorImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.supportedProtocols = new LazyList();
        this.contactPersons = new XMLObjectChildrenList((XMLObject)this);
        this.keyDescriptors = new XMLObjectChildrenList((XMLObject)this);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    public boolean isValid() {
        if (this.validUntil != null) {
            return this.validUntil.isBeforeNow();
        }
        return true;
    }

    @Override
    public DateTime getValidUntil() {
        return this.validUntil;
    }

    @Override
    public void setValidUntil(DateTime validUntil) {
        this.validUntil = this.prepareForAssignment(this.validUntil, validUntil);
    }

    @Override
    public Long getCacheDuration() {
        return this.cacheDuration;
    }

    @Override
    public void setCacheDuration(Long duration) {
        this.cacheDuration = (Long)this.prepareForAssignment(this.cacheDuration, duration);
    }

    @Override
    public List<String> getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    @Override
    public boolean isSupportedProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol);
    }

    @Override
    public void addSupportedProtocol(String protocol) {
        if ((protocol = DatatypeHelper.safeTrimOrNullString((String)protocol)) != null && !this.supportedProtocols.contains(protocol)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.add(protocol);
        }
    }

    @Override
    public void removeSupportedProtocol(String protocol) {
        if ((protocol = DatatypeHelper.safeTrimOrNullString((String)protocol)) != null && this.supportedProtocols.contains(protocol)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.remove(protocol);
        }
    }

    @Override
    public void removeSupportedProtocols(Collection<String> protocols) {
        for (String protocol : protocols) {
            this.removeSupportedProtocol(protocol);
        }
    }

    @Override
    public void removeAllSupportedProtocols() {
        for (String protocol : this.supportedProtocols) {
            this.removeSupportedProtocol(protocol);
        }
    }

    @Override
    public String getErrorURL() {
        return this.errorURL;
    }

    @Override
    public void setErrorURL(String errorURL) {
        this.errorURL = this.prepareForAssignment(this.errorURL, errorURL);
    }

    @Override
    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(Extensions extensions) throws IllegalArgumentException {
        this.extensions = (Extensions)this.prepareForAssignment((XMLObject)this.extensions, (XMLObject)extensions);
    }

    @Override
    public Organization getOrganization() {
        return this.organization;
    }

    @Override
    public void setOrganization(Organization organization) throws IllegalArgumentException {
        this.organization = (Organization)this.prepareForAssignment((XMLObject)this.organization, (XMLObject)organization);
    }

    @Override
    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    @Override
    public List<KeyDescriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @Override
    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        if (this.extensions != null) {
            children.add(this.getExtensions());
        }
        children.addAll(this.getKeyDescriptors());
        if (this.organization != null) {
            children.add(this.getOrganization());
        }
        children.addAll(this.getContactPersons());
        return Collections.unmodifiableList(children);
    }
}

