/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import org.italiangrid.voms.util.VOMSFQANNamingScheme;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

class VOMSRequestFragment {
    private Document doc;
    DocumentFragment fragment;
    Element root;
    Element command;
    Element order;
    Element targets;
    Element lifetime;
    Element base64;
    Element version;

    public VOMSRequestFragment(Document doc) {
        this.doc = doc;
        this.fragment = doc.createDocumentFragment();
        this.buildRootElement();
    }

    protected void buildRootElement() {
        this.root = this.doc.createElement("voms");
        this.fragment.appendChild(this.root);
    }

    private void appendTextChild(Element e, String text) {
        e.appendChild(this.doc.createTextNode(text));
    }

    private String buildCompatibleOrderString(String s) {
        String[] FQANs = s.split(",");
        if (FQANs.length == 0) {
            return "";
        }
        for (int i = 0; i < FQANs.length; ++i) {
            if (!VOMSFQANNamingScheme.isQualifiedRole(FQANs[i])) continue;
            FQANs[i] = VOMSFQANNamingScheme.toOldQualifiedRoleSyntax(FQANs[i]);
        }
        StringBuilder fqansString = new StringBuilder();
        for (int i = 0; i < FQANs.length; ++i) {
            fqansString.append(FQANs);
            if (i >= FQANs.length - 1) continue;
            fqansString.append(",");
        }
        return fqansString.toString();
    }

    void buildCommandElement(String cmdString) {
        this.command = this.doc.createElement("command");
        this.appendTextChild(this.command, cmdString);
        this.root.appendChild(this.command);
    }

    void buildOrderElement(String orderString) {
        this.order = this.doc.createElement("order");
        this.appendTextChild(this.order, this.buildCompatibleOrderString(orderString));
        this.root.appendChild(this.order);
    }

    void buildTargetsElement(String targetString) {
        this.targets = this.doc.createElement("targets");
        this.appendTextChild(this.targets, targetString);
        this.root.appendChild(this.targets);
    }

    void buildLifetime(long lifetime) {
        this.buildLifetime(Long.toString(lifetime));
    }

    void buildLifetime(String lifetimeString) {
        this.lifetime = this.doc.createElement("lifetime");
        this.appendTextChild(this.lifetime, lifetimeString);
        this.root.appendChild(this.lifetime);
    }

    void buildBase64() {
        this.base64 = this.doc.createElement("base64");
        this.appendTextChild(this.base64, "1");
        this.root.appendChild(this.base64);
    }

    void buildVersion() {
        this.version = this.doc.createElement("version");
        this.appendTextChild(this.version, "4");
        this.root.appendChild(this.version);
    }

    public DocumentFragment getFragment() {
        return this.fragment;
    }

    public void groupCommand(String groupName) {
        this.buildCommandElement("G" + groupName);
    }

    public void roleCommand(String roleName) {
        this.buildCommandElement("R" + roleName);
    }

    public void mappingCommand(String groupName, String roleName) {
        this.buildCommandElement("B" + groupName + ":" + roleName);
    }

    public void allCommand() {
        this.buildCommandElement("A");
    }

    public void listCommand() {
        this.buildCommandElement("N");
    }
}

