/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.service.acl;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.glite.security.voms.service.acl.VOMSACL;
import org.glite.security.voms.service.acl.VOMSACLService;
import org.glite.security.voms.service.acl.VOMSACLSoapBindingStub;

public class VOMSACLServiceLocator
extends Service
implements VOMSACLService {
    private String VOMSACL_address = "https://localhost:8443/glite-security-voms-admin-interface/VOMSACL";
    private String VOMSACLWSDDServiceName = "VOMSACL";
    private HashSet ports = null;

    public VOMSACLServiceLocator() {
    }

    public VOMSACLServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public VOMSACLServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getVOMSACLAddress() {
        return this.VOMSACL_address;
    }

    public String getVOMSACLWSDDServiceName() {
        return this.VOMSACLWSDDServiceName;
    }

    public void setVOMSACLWSDDServiceName(String name) {
        this.VOMSACLWSDDServiceName = name;
    }

    @Override
    public VOMSACL getVOMSACL() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.VOMSACL_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getVOMSACL(endpoint);
    }

    @Override
    public VOMSACL getVOMSACL(URL portAddress) throws ServiceException {
        try {
            VOMSACLSoapBindingStub _stub = new VOMSACLSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getVOMSACLWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setVOMSACLEndpointAddress(String address) {
        this.VOMSACL_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (VOMSACL.class.isAssignableFrom(serviceEndpointInterface)) {
                VOMSACLSoapBindingStub _stub = new VOMSACLSoapBindingStub(new URL(this.VOMSACL_address), this);
                _stub.setPortName(this.getVOMSACLWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("VOMSACL".equals(inputPortName)) {
            return this.getVOMSACL();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://glite.org/wsdl/services/org.glite.security.voms.service.acl", "VOMSACLService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://glite.org/wsdl/services/org.glite.security.voms.service.acl", "VOMSACL"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"VOMSACL".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setVOMSACLEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

