/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.util;

import com.opensymphony.xwork2.conversion.TypeConversionException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.struts2.util.StrutsTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedLocaleDateTypeConverter
extends StrutsTypeConverter {
    public static final Logger log = LoggerFactory.getLogger(FixedLocaleDateTypeConverter.class);

    public Object convertFromString(Map context, String[] values, Class toClass) {
        String dateString = values[0];
        log.debug("Converting from String {} to date.", (Object)dateString);
        Date date = this.parseDate(dateString);
        return date;
    }

    public String convertToString(Map context, Object o) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
        Date d = (Date)o;
        log.debug("Converting from Date {} to string.", (Object)d.toString());
        return formatter.format(d);
    }

    Date parseDate(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
        try {
            Date date = formatter.parse(dateString);
            return date;
        }
        catch (ParseException e) {
            log.warn("Error parsing date: {}", (Object)dateString);
            log.debug(e.getMessage(), (Throwable)e);
            throw new TypeConversionException("Error parsing date: " + dateString, (Throwable)e);
        }
    }
}

