/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.interceptor.ExceptionMappingInterceptor;
import org.glite.security.voms.admin.error.VOMSAuthorizationException;
import org.glite.security.voms.admin.view.actions.AuthorizationErrorAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzExceptionInterceptor
extends ExceptionMappingInterceptor {
    public static final String ERROR_KEY = "voms-authorization-error";
    public static final Logger log = LoggerFactory.getLogger(AuthzExceptionInterceptor.class);
    private static final long serialVersionUID = 1L;

    public String intercept(ActionInvocation ai) throws Exception {
        try {
            String result = ai.invoke();
            return result;
        }
        catch (Exception e) {
            if (e instanceof VOMSAuthorizationException) {
                log.debug("Caught VOMS authorization exception: " + e);
                if (ai.getAction() instanceof ValidationAware) {
                    ValidationAware vaAction = (ValidationAware)ai.getAction();
                    vaAction.addActionError(e.getMessage());
                }
                if (ai.getAction() instanceof AuthorizationErrorAware) {
                    AuthorizationErrorAware aeaAction = (AuthorizationErrorAware)ai.getAction();
                    return aeaAction.getAuthorizationErrorResult();
                }
                return "input";
            }
            throw e;
        }
    }
}

