/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import com.opensymphony.xwork2.validator.annotations.DateRangeFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.Date;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.users.SetMembershipExpirationOperation;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;

@Results(value={@Result(name="success", location="membershipExpiration.jsp"), @Result(name="input", location="membershipExpiration.jsp")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class SetMembershipExpirationAction
extends UserActionSupport {
    private static final long serialVersionUID = 1L;
    Date expirationDate;

    public void validate() {
        Date now = new Date();
        if (this.expirationDate == null) {
            this.addFieldError("expirationDate", "Please enter a valid expiration date for the user.");
        } else if (now.after(this.expirationDate)) {
            this.addFieldError("expirationDate", "Please enter a future expiration date for the user.");
        }
    }

    public String execute() throws Exception {
        SetMembershipExpirationOperation op = new SetMembershipExpirationOperation(this.getModel(), this.expirationDate);
        op.execute();
        this.addActionMessage("Membership expiration date changed.");
        return "success";
    }

    @RequiredFieldValidator(type=ValidatorType.FIELD, message="Please set a membership expiration date for the user.")
    @DateRangeFieldValidator(type=ValidatorType.FIELD, message="Please enter a valid expiration date for the user.", min="12/25/2010")
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }
}

