/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.RoleMembershipSubmittedEvent;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.error.NoSuchRoleException;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.request.RoleMembershipRequest;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;

@Results(value={@Result(name="success", location="mappingsRequest.jsp"), @Result(name="error", location="mappingsRequest.jsp"), @Result(name="input", location="mappingsRequest.jsp")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class RequestRoleMembershipAction
extends UserActionSupport {
    private static final long serialVersionUID = 1L;
    Long groupId;
    Long roleId;

    public void validate() {
        RequestDAO reqDAO = DAOFactory.instance().getRequestDAO();
        VOMSGroup g = this.groupById(this.groupId);
        VOMSRole r = this.roleById(this.roleId);
        if (g == null) {
            throw new NoSuchGroupException("Group with id '" + this.groupId + "' not found!");
        }
        if (r == null) {
            throw new NoSuchRoleException("Role with id '" + this.roleId + "' not found!");
        }
        if (this.model.hasRole(g, r)) {
            this.addActionError(this.getText("role_request.user.already_member", new String[]{this.model.toString(), r.getName(), g.getName()}));
        }
        if (reqDAO.userHasPendingRoleMembershipRequest(this.model, g, r)) {
            this.addActionError(this.getText("role_request.user.has_pending_request", new String[]{this.model.toString(), r.getName(), g.getName()}));
        }
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String execute() throws Exception {
        if (!VOMSConfiguration.instance().getBoolean("voms.registration.enabled", true)) {
            return "registrationDisabled";
        }
        if (this.hasActionErrors()) {
            return "error";
        }
        RequestDAO reqDAO = DAOFactory.instance().getRequestDAO();
        VOMSGroup g = this.groupById(this.groupId);
        VOMSRole r = this.roleById(this.roleId);
        RoleMembershipRequest request = reqDAO.createRoleMembershipRequest(this.model, g, r, this.getDefaultFutureDate());
        EventManager.dispatch(new RoleMembershipSubmittedEvent(request, this.getHomeURL()));
        this.refreshPendingRequests();
        return "success";
    }
}

