/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.CertificateRequestSubmittedEvent;
import org.glite.security.voms.admin.persistence.dao.CertificateDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.model.request.CertificateRequest;
import org.glite.security.voms.admin.util.CertUtil;
import org.glite.security.voms.admin.util.DNUtil;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;

@Results(value={@Result(name="success", location="userHome"), @Result(name="error", location="certificateRequest.jsp"), @Result(name="input", location="requestCertificate")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class RequestCertificateAction
extends UserActionSupport {
    private static final long serialVersionUID = 1L;
    File certificateFile;
    String subject;
    String caSubject;

    public void validate() {
        CertificateDAO dao = CertificateDAO.instance();
        RequestDAO reqDAO = DAOFactory.instance().getRequestDAO();
        if (this.certificateFile != null) {
            X509Certificate cert = null;
            try {
                cert = CertUtil.parseCertficate(new FileInputStream(this.certificateFile));
            }
            catch (Throwable e) {
                this.addFieldError("certificateFile", "Error parsing certificate passed as argument. Please upload a valid X509, PEM encoded certificate.");
                return;
            }
            if (cert == null) {
                this.addFieldError("certificateFile", "Error parsing certificate passed as argument!");
                return;
            }
            if (dao.find(cert) != null) {
                this.addFieldError("certificateFile", "Certificate already bound!");
            }
            this.subject = DNUtil.getOpenSSLSubject(cert.getSubjectX500Principal());
            this.caSubject = DNUtil.getOpenSSLSubject(cert.getIssuerX500Principal());
            if (reqDAO.userHasPendingCertificateRequest(this.model, this.subject, this.caSubject)) {
                this.addFieldError("certificateFile", "You already have a pending request for this certificate!");
            }
        } else if (this.subject != null && !"".equals(this.subject)) {
            if (dao.findByDNCA(this.subject, this.caSubject) != null) {
                this.addFieldError("subject", "Certificate already bound!");
                this.addFieldError("caSubject", "Certificate already bound!");
                return;
            }
            if (reqDAO.userHasPendingCertificateRequest(this.model, this.subject, this.caSubject)) {
                this.addFieldError("subject", "You already have a pending request for this certificate!");
                this.addFieldError("caSubject", "You already have a pending request for this certificate!");
            }
        } else {
            this.addActionError("Please specify a Subject, CA couple or choose a certificate file that will be uploaded to the server!");
        }
    }

    public File getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateFile(File certificateFile) {
        this.certificateFile = certificateFile;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The subject field name contains illegal characters!", expression="^[^<>&;]*$")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The subject field name contains illegal characters!", expression="^[^<>&;]*$")
    public String getCaSubject() {
        return this.caSubject;
    }

    public void setCaSubject(String caSubject) {
        this.caSubject = caSubject;
    }

    public String execute() throws Exception {
        if (!VOMSConfiguration.instance().getBoolean("voms.registration.enabled", true)) {
            return "registrationDisabled";
        }
        RequestDAO reqDAO = DAOFactory.instance().getRequestDAO();
        CertificateRequest req = reqDAO.createCertificateRequest(this.getModel(), this.getSubject(), this.getCaSubject(), this.getDefaultFutureDate());
        EventManager.dispatch(new CertificateRequestSubmittedEvent(req, this.getHomeURL()));
        this.refreshPendingRequests();
        return "success";
    }
}

