/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.groups.AddMemberOperation;
import org.glite.security.voms.admin.operations.groups.RemoveMemberOperation;
import org.glite.security.voms.admin.operations.users.AssignRoleOperation;
import org.glite.security.voms.admin.operations.users.DismissRoleOperation;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Results(value={@Result(name="success", location="mappings.jsp"), @Result(name="input", location="mappings.jsp"), @Result(name="invalid.token", location="mappings.jsp")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "assignRole,addToGroup,removeFromGroup,dismissRole"})
public class MembershipActions
extends UserActionSupport {
    public static final Logger log = LoggerFactory.getLogger(MembershipActions.class);
    private static final long serialVersionUID = 1L;
    Long groupId;
    Long roleId;

    @Action(value="add-to-group")
    public String addToGroup() throws Exception {
        VOMSGroup g = this.groupById(this.groupId);
        AddMemberOperation.instance(this.getModel(), g).execute();
        this.addActionMessage(this.getText("confirm.user.add_to_group", new String[]{this.model.getShortName(), g.toString()}));
        return "success";
    }

    @Action(value="remove-from-group")
    public String removeFromGroup() throws Exception {
        VOMSGroup g = this.groupById(this.groupId);
        RemoveMemberOperation.instance(this.getModel(), g).execute();
        this.addActionMessage(this.getText("confirm.user.remove_from_group", new String[]{this.model.getShortName(), g.toString()}));
        return "success";
    }

    @Action(value="assign-role")
    public String assignRole() throws Exception {
        VOMSGroup g = this.groupById(this.groupId);
        VOMSRole r = this.roleById(this.roleId);
        AssignRoleOperation.instance(this.getModel(), g, r).execute();
        this.addActionMessage(this.getText("confirm.user.assign_role", new String[]{this.getModel().getShortName(), r.toString(), g.toString()}));
        return "success";
    }

    @Action(value="dismiss-role")
    public String dismissRole() throws Exception {
        VOMSGroup g = this.groupById(this.groupId);
        VOMSRole r = this.roleById(this.roleId);
        DismissRoleOperation.instance(this.getModel(), g, r).execute();
        this.addActionMessage(this.getText("confirm.user.dismiss_role", new String[]{this.getModel().getShortName(), r.toString(), g.toString()}));
        return "success";
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }
}

