/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.users.CreateUserOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;

@Results(value={@Result(name="input", location="userCreate"), @Result(name="success", location="load", type="redirectAction")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class CreateAction
extends UserActionSupport {
    private static final long serialVersionUID = 1L;
    String theName;
    String theSurname;
    String theInstitution;
    String theAddress;
    String thePhoneNumber;
    String theEmailAddress;
    String subject;
    String caSubject;

    public String execute() throws Exception {
        if (this.getModel() != null) {
            return "edit";
        }
        VOMSUser newUser = new VOMSUser();
        newUser.setName(this.theName);
        newUser.setSurname(this.theSurname);
        newUser.setInstitution(this.theInstitution);
        newUser.setAddress(this.theAddress);
        newUser.setPhoneNumber(this.thePhoneNumber);
        newUser.setEmailAddress(this.theEmailAddress);
        newUser.setDn(this.subject.trim());
        CreateUserOperation op = CreateUserOperation.instance(newUser, this.caSubject);
        this.model = (VOMSUser)op.execute();
        VOMSUserDAO.instance().signAUP(this.model, DAOFactory.instance().getAUPDAO().getVOAUP());
        this.theSession.put(LOAD_THIS_USER_KEY, this.model.getId());
        return "success";
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The name field contains illegal characters!", expression="^[^<>&=;]*$")
    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter a name for the user.")
    public String getTheName() {
        return this.theName;
    }

    public void setTheName(String theName) {
        this.theName = theName;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter a family name for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The surname field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheSurname() {
        return this.theSurname;
    }

    public void setTheSurname(String theSurname) {
        this.theSurname = theSurname;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter an institution for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The institution field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheInstitution() {
        return this.theInstitution;
    }

    public void setTheInstitution(String theInstitution) {
        this.theInstitution = theInstitution;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter an address for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The address field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheAddress() {
        return this.theAddress;
    }

    public void setTheAddress(String theAddress) {
        this.theAddress = theAddress;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter a phoneNumber for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The phoneNumber field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getThePhoneNumber() {
        return this.thePhoneNumber;
    }

    public void setThePhoneNumber(String thePhoneNumber) {
        this.thePhoneNumber = thePhoneNumber;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter an email address for the user.")
    @EmailValidator(type=ValidatorType.FIELD, message="Please enter a valid email address.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The email field name contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheEmailAddress() {
        return this.theEmailAddress;
    }

    public void setTheEmailAddress(String theEmailAddress) {
        this.theEmailAddress = theEmailAddress;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter a certificate subject for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The subject field name contains illegal characters!", expression="^[^<>&;]*$")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCaSubject() {
        return this.caSubject;
    }

    public void setCaSubject(String caSubject) {
        this.caSubject = caSubject;
    }

    public void validate() {
        VOMSUser candidate = VOMSUserDAO.instance().findByDNandCA(this.subject, this.caSubject);
        if (candidate != null) {
            this.addFieldError("subject", "A user having this certificate already exists in the VO!");
            this.addFieldError("caSubject", "A user having this certificate already exists in the VO!");
        }
    }
}

