/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import java.io.File;
import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.users.AddUserCertificateOperation;
import org.glite.security.voms.admin.operations.users.RemoveUserCertificateOperation;
import org.glite.security.voms.admin.persistence.dao.CertificateDAO;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.util.CertUtil;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Results(value={@Result(name="success", location="userDetail"), @Result(name="input", location="addCertificate")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "deleteCertificate,saveCertificate"})
public class CertificateActions
extends UserActionSupport {
    public static final Logger log = LoggerFactory.getLogger(CertificateActions.class);
    private static final long serialVersionUID = 1L;
    Long certificateId;
    File certificateFile;
    String subject;
    String caSubject;

    @Action(value="delete-certificate")
    public String deleteCertificate() throws Exception {
        Certificate cert = CertificateDAO.instance().findById(this.getCertificateId());
        RemoveUserCertificateOperation.instance(cert.getSubjectString(), cert.getCa().getSubjectString()).execute();
        return "success";
    }

    @Action(value="add-certificate")
    public String addCertificate() throws Exception {
        return "input";
    }

    @Action(value="save-certificate")
    public String saveCertificate() throws Exception {
        if (this.certificateFile != null) {
            X509Certificate cert = CertUtil.parseCertficate(new FileInputStream(this.certificateFile));
            AddUserCertificateOperation.instance(this.getModel(), cert).execute();
        } else {
            AddUserCertificateOperation.instance(this.getModel(), this.subject.trim(), this.caSubject.trim(), null).execute();
        }
        return "success";
    }

    public void validateSaveCertificate() {
        CertificateDAO dao = CertificateDAO.instance();
        if (this.certificateFile != null) {
            X509Certificate cert = null;
            try {
                cert = CertUtil.parseCertficate(new FileInputStream(this.certificateFile));
            }
            catch (Throwable e) {
                this.addFieldError("certificateFile", "Error parsing certificate passed as argument: " + e.getMessage() + ". Please upload a valid X509, PEM encoded certificate.");
                return;
            }
            if (cert == null) {
                this.addFieldError("certificateFile", "Error parsing certificate passed as argument!");
                return;
            }
            if (dao.find(cert) != null) {
                this.addFieldError("certificateFile", "Certificate already bound!");
            }
        } else if (this.subject != null && !"".equals(this.subject)) {
            if (dao.findByDNCA(this.subject, this.caSubject) != null) {
                this.addFieldError("subject", "Certificate already bound!");
                this.addFieldError("caSubject", "Certificate already bound!");
            }
        } else {
            this.addActionError("Please specify a Subject, CA couple or choose a certificate file that will be uploaded to the server!");
        }
    }

    public File getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateFile(File certificateFile) {
        this.certificateFile = certificateFile;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCaSubject() {
        return this.caSubject;
    }

    public void setCaSubject(String caSubject) {
        this.caSubject = caSubject;
    }

    public Long getCertificateId() {
        return this.certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }
}

