/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.search;

import com.opensymphony.xwork2.validator.annotations.VisitorFieldValidator;
import java.util.Map;
import org.apache.struts2.interceptor.SessionAware;
import org.glite.security.voms.admin.operations.search.BaseSearchOperation;
import org.glite.security.voms.admin.persistence.dao.SearchResults;
import org.glite.security.voms.admin.view.actions.BaseAction;
import org.glite.security.voms.admin.view.actions.SearchData;

public abstract class BaseSearchAction
extends BaseAction
implements SessionAware {
    private static final long serialVersionUID = 1L;
    public static final String USER_SEARCH_NAME = "user";
    public static final String GROUP_SEARCH_NAME = "group";
    public static final String ROLE_SEARCH_NAME = "role";
    public static final String ATTRIBUTE_SEARCH_NAME = "attribute";
    public static final String MEMBER_SEARCH_NAME = "member";
    public static final String GROUP_MEMBER_SEARCH_NAME = "group-member";
    public static final String ROLE_MEMBER_SEARCH_NAME = "role-member";
    protected SearchData searchData;
    protected SearchResults searchResults;
    protected Map<String, Object> session;

    @VisitorFieldValidator(appendPrefix=true, message="Invalid input:  ")
    public SearchData getSearchData() {
        return this.searchData;
    }

    public void setSearchData(SearchData searchData) {
        this.searchData = searchData;
    }

    public String execute() throws Exception {
        this.searchResults = (SearchResults)BaseSearchOperation.instance(this.getSearchData()).execute();
        this.session.put("searchData", this.getSearchData());
        this.session.put("searchResults", this.searchResults);
        this.cleanupCustomFlags();
        return "success";
    }

    public SearchResults getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(SearchResults searchResults) {
        this.searchResults = searchResults;
    }

    protected void initSearchData(String searchType) {
        if (this.getSearchData() == null) {
            SearchData sd = new SearchData();
            sd.setType(searchType);
            this.setSearchData(sd);
        } else {
            this.getSearchData().setType(searchType);
        }
    }

    protected void cleanupCustomFlags() {
        this.session.remove("searchParams");
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }
}

