/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.role;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.roles.CreateRoleOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.view.actions.role.RoleActionSupport;

@Results(value={@Result(name="success", location="search", type="redirectAction"), @Result(name="input", location="roleCreate"), @Result(name="invalid.token", location="roleCreate")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class CreateAction
extends RoleActionSupport {
    private static final long serialVersionUID = 1L;
    VOMSRole role;
    String roleName;

    @Override
    public VOMSRole getModel() {
        return this.role;
    }

    @Override
    public void prepare() throws Exception {
    }

    public String execute() throws Exception {
        VOMSRole r = (VOMSRole)CreateRoleOperation.instance(this.getRoleName()).execute();
        if (r != null) {
            this.addActionMessage(this.getText("confirm.role.creation", r.getName()));
        }
        return "success";
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="A name for the role is required!")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The role name field contains illegal characters!", expression="^[\\w.-]+$")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void validate() {
        if (this.getRoleName().contains("/")) {
            this.addFieldError("roleName", "'" + this.getRoleName() + "' is not a valid VOMS role name.");
            return;
        }
        VOMSRole r = VOMSRoleDAO.instance().findByName(this.roleName);
        if (r != null) {
            this.addFieldError("roleName", "Role '" + this.roleName + "' already exists!");
        }
    }
}

