/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.register.orgdb;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.integration.PluginConfigurator;
import org.glite.security.voms.admin.integration.PluginManager;
import org.glite.security.voms.admin.integration.orgdb.OrgDBConfigurator;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBDAOFactory;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBVOMSPersonDAO;
import org.glite.security.voms.admin.integration.orgdb.model.VOMSOrgDBPerson;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.persistence.model.request.RequesterInfo;
import org.glite.security.voms.admin.view.actions.BaseAction;

@Results(value={@Result(name="success", location="searchResults.jsp"), @Result(name="input", location="searchResults.jsp")})
public class QueryDatabaseAction
extends BaseAction
implements ModelDriven<List<VOMSOrgDBPerson>>,
Preparable {
    private static final long serialVersionUID = 1L;
    protected RequesterInfo requester;
    String emailAddress;
    String name;
    String surname;
    List<VOMSOrgDBPerson> searchResults;
    String experimentName;

    protected RequesterInfo requesterInfoFromCurrentAdmin() {
        RequesterInfo i = new RequesterInfo();
        CurrentAdmin admin = CurrentAdmin.instance();
        i.setCertificateSubject(admin.getRealSubject());
        i.setCertificateIssuer(admin.getRealIssuer());
        i.setEmailAddress(admin.getRealEmailAddress());
        return i;
    }

    public void prepare() throws Exception {
        this.requester = this.requesterInfoFromCurrentAdmin();
    }

    public String execute() throws Exception {
        try {
            this.requester.setName(this.name);
            this.requester.setSurname(this.surname);
            this.requester.setEmailAddress(this.emailAddress);
            PluginConfigurator configuredPlugin = PluginManager.instance().getConfiguredPlugin(OrgDBConfigurator.class.getName());
            this.experimentName = configuredPlugin.getPluginProperty("experimentName");
            OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
            this.searchResults = new ArrayList<VOMSOrgDBPerson>();
            VOMSOrgDBPerson exactMatch = dao.findPersonWithValidExperimentParticipationByEmail(this.emailAddress, this.experimentName);
            if (exactMatch == null) {
                this.searchResults = dao.findPersonsWithValidExperimentParticipationByName(this.name, this.surname, this.experimentName);
                if (this.searchResults.isEmpty()) {
                    this.addActionError(String.format("No valid participation found for '%s %s' for experiment '%s'", this.name, this.surname, this.experimentName));
                } else {
                    this.addActionMessage(String.format("Matches found for name '%s %s' for experiment '%s'", this.name, this.surname, this.experimentName));
                }
            } else {
                this.addActionMessage("Found the following match for email '" + this.emailAddress + "'.");
                this.searchResults.add(exactMatch);
            }
        }
        catch (Exception e) {
            this.addActionError(e.getMessage());
        }
        return "success";
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your email address.")
    @EmailValidator(type=ValidatorType.FIELD, message="Please enter a valid email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your surname.")
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public List<VOMSOrgDBPerson> getModel() {
        return this.searchResults;
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public RequesterInfo getRequester() {
        return this.requester;
    }
}

