/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.register;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.glite.security.voms.admin.persistence.model.request.NewVOMembershipRequest;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.persistence.model.request.RequesterInfo;
import org.glite.security.voms.admin.view.actions.BaseAction;

@Results(value={@Result(name="input", location="register"), @Result(name="success", location="registerConfirmation")})
public abstract class RegisterActionSupport
extends BaseAction
implements Preparable,
ModelDriven<NewVOMembershipRequest> {
    public static final String CONFIRMATION_NEEDED = "needToConfirm";
    public static final String PLEASE_WAIT = "pleaseWait";
    public static final String ALREADY_MEMBER = "alreadyAMember";
    public static final String REGISTRATION_DISABLED = "registrationDisabled";
    public static final String UNAUTHENTICATED_CLIENT = "unauthenticatedClient";
    public static final String PLUGIN_VALIDATION_ERROR = "pluginValidationError";
    private static final long serialVersionUID = 1L;
    Long requestId = -1L;
    protected NewVOMembershipRequest request;
    protected RequesterInfo requester;
    AUPVersion currentAUPVersion;

    protected String checkExistingPendingRequests() {
        RequestDAO dao = DAOFactory.instance().getRequestDAO();
        NewVOMembershipRequest req = dao.findActiveVOMembershipRequest(this.requester);
        if (req != null) {
            this.request = req;
            if (req.getStatus().equals((Object)Request.STATUS.SUBMITTED)) {
                return CONFIRMATION_NEEDED;
            }
            if (req.getStatus().equals((Object)Request.STATUS.CONFIRMED) || req.getStatus().equals((Object)Request.STATUS.PENDING)) {
                return PLEASE_WAIT;
            }
        }
        return null;
    }

    protected RequesterInfo requesterInfoFromCurrentAdmin() {
        RequesterInfo i = new RequesterInfo();
        CurrentAdmin admin = CurrentAdmin.instance();
        i.setCertificateSubject(admin.getRealSubject());
        i.setCertificateIssuer(admin.getRealIssuer());
        i.setEmailAddress(admin.getRealEmailAddress());
        return i;
    }

    public void prepare() throws Exception {
        this.requester = this.requesterInfoFromCurrentAdmin();
        AUPDAO aupDAO = DAOFactory.instance().getAUPDAO();
        this.currentAUPVersion = aupDAO.getVOAUP().getActiveVersion();
        if (this.getModel() == null && this.requestId != -1L) {
            RequestDAO dao = DAOFactory.instance().getRequestDAO();
            this.request = (NewVOMembershipRequest)dao.findById(this.requestId, true);
        }
    }

    public NewVOMembershipRequest getModel() {
        return this.request;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public RequesterInfo getRequester() {
        return this.requester;
    }

    public void setRequester(RequesterInfo requester) {
        this.requester = requester;
    }

    public boolean registrationEnabled() {
        return VOMSConfiguration.instance().getBoolean("voms.registration.enabled", true);
    }

    public boolean attributeRequestsEnabled() {
        return VOMSConfiguration.instance().getBoolean("voms.request.vo_membership.enable_attribute_requests", false);
    }

    public AUPVersion getCurrentAUPVersion() {
        return this.currentAUPVersion;
    }

    public String getRegistrationType() {
        return VOMSConfiguration.instance().getRegistrationType();
    }
}

