/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.register;

import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.List;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.VOMembershipRequestConfirmedEvent;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.view.actions.register.RegisterActionSupport;

@Results(value={@Result(name="input", location="register"), @Result(name="success", location="registrationConfirmed"), @Result(name="error", location="registrationConfirmationError"), @Result(name="REQUEST_ATTRIBUTES", location="requestAttributes")})
public class ConfirmRequestAction
extends RegisterActionSupport {
    private static final long serialVersionUID = 1L;
    public static final String REQUEST_ATTRIBUTES = "REQUEST_ATTRIBUTES";
    String confirmationId;

    public String execute() throws Exception {
        if (!this.registrationEnabled()) {
            return "registrationDisabled";
        }
        if (!this.getModel().getStatus().equals((Object)Request.STATUS.SUBMITTED)) {
            this.addActionError("Your request has already been confirmed!");
            return "error";
        }
        List<VOMSGroup> groups = VOMSGroupDAO.instance().getAll();
        if (this.attributeRequestsEnabled() && groups.size() > 1) {
            if (groups.size() > 1) {
                groups = groups.subList(1, groups.size());
            }
            ServletActionContext.getRequest().setAttribute("voGroups", groups);
            return REQUEST_ATTRIBUTES;
        }
        if (!this.getModel().getConfirmId().equals(this.confirmationId)) {
            this.addActionError("Wrong confirmation id!");
            return "error";
        }
        this.request.setStatus(Request.STATUS.CONFIRMED);
        String manageURL = this.getBaseURL() + "/home/login.action";
        EventManager.dispatch(new VOMembershipRequestConfirmedEvent(this.request, manageURL));
        return "success";
    }

    @RequiredFieldValidator(type=ValidatorType.FIELD, message="A confirmation id is required!")
    public String getConfirmationId() {
        return this.confirmationId;
    }

    public void setConfirmationId(String confirmationId) {
        this.confirmationId = confirmationId;
    }
}

