/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.group;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.StringLengthFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.error.VOMSSyntaxException;
import org.glite.security.voms.admin.operations.groups.CreateGroupOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.glite.security.voms.admin.view.actions.group.GroupActionSupport;

@Results(value={@Result(name="success", location="search", type="redirectAction"), @Result(name="input", location="groupCreate"), @Result(name="invalid.token", location="groupCreate")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class CreateAction
extends GroupActionSupport {
    private static final long serialVersionUID = 1L;
    VOMSGroup group;
    String groupName;
    String parentGroupName;
    String description;
    Boolean isRestricted;

    public void validate() {
        String candidateName = this.getParentGroupName() + "/" + this.getGroupName();
        if (this.getGroupName().contains("/")) {
            this.addFieldError("groupName", "The group name '" + this.getGroupName() + "' is invalid. It should not contain the '/' character.");
            return;
        }
        try {
            PathNamingScheme.isGroup(candidateName);
        }
        catch (VOMSSyntaxException e) {
            this.addFieldError("groupName", "'" + this.getGroupName() + "' is not a valid group name!");
            return;
        }
        VOMSGroup target = VOMSGroupDAO.instance().findByName(candidateName);
        if (target != null) {
            this.addFieldError("groupName", "Group '" + candidateName + "' already exists!");
        }
    }

    public String execute() throws Exception {
        VOMSGroup g;
        if (this.groupName == null && this.parentGroupName == null) {
            return "input";
        }
        String name = this.getParentGroupName() + "/" + this.getGroupName();
        if ("".equals(this.description.trim())) {
            this.description = null;
        }
        if ((g = (VOMSGroup)CreateGroupOperation.instance(name, this.description, this.isRestricted).execute()) != null) {
            this.addActionMessage(this.getText("confirm.group.creation", g.getName()));
        }
        return "success";
    }

    @Override
    public VOMSGroup getModel() {
        return this.group;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="A name for the group is required!")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The group name field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getParentGroupName() {
        return this.parentGroupName;
    }

    public void setParentGroupName(String parentGroupName) {
        this.parentGroupName = parentGroupName;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The description field contains illegal characters!", expression="^[^<>&=;]*$")
    @StringLengthFieldValidator(type={ValidatorType.FIELD}, maxLength="255", message="The description field size is limited to 255 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getIsRestricted() {
        return this.isRestricted;
    }

    public void setIsRestricted(Boolean isRestricted) {
        this.isRestricted = isRestricted;
    }

    @Override
    public void prepare() throws Exception {
    }
}

