/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.aup;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.view.actions.BaseAction;

@Results(value={@Result(name="input", location="signAup"), @Result(name="success", location="/home/login.action", type="redirect")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class SignAction
extends BaseAction
implements ModelDriven<AUP>,
Preparable {
    private static final long serialVersionUID = 1L;
    Long aupId;
    String aupAccepted;
    AUP aup;

    public String execute() throws Exception {
        VOMSUser u = CurrentAdmin.instance().getVoUser();
        if (u == null) {
            throw new VOMSException("Current authenticated client is not a member of the VO and, as such, cannot be entitled to sign AUP for the VO.");
        }
        if (!this.aupAccepted.equals("true")) {
            this.addFieldError("aupAccepted", "You have to accept the terms of the AUP to proceed!");
            return "input";
        }
        VOMSUserDAO.instance().signAUP(u, this.aup);
        return "success";
    }

    public AUP getModel() {
        return this.aup;
    }

    public Long getAupId() {
        return this.aupId;
    }

    public void setAupId(Long aupId) {
        this.aupId = aupId;
    }

    public void prepare() throws Exception {
        if (this.aup == null) {
            AUPDAO dao = DAOFactory.instance().getAUPDAO();
            this.aup = dao.getVOAUP();
        }
    }

    @RequiredFieldValidator(type=ValidatorType.FIELD, message="You must sign the AUP.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^true$", message="You must accept the terms of the AUP to proceed")
    public String getAupAccepted() {
        return this.aupAccepted;
    }

    public void setAupAccepted(String aupAccepted) {
        this.aupAccepted = aupAccepted;
    }
}

