/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.attribute;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.glite.security.voms.admin.operations.attributes.CreateAttributeDescriptionOperation;
import org.glite.security.voms.admin.operations.attributes.DeleteAttributeDescriptionOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSAttributeDAO;
import org.glite.security.voms.admin.persistence.model.VOMSAttributeDescription;
import org.glite.security.voms.admin.view.actions.BaseAction;

@Results(value={@Result(name="success", location="/attribute/search.action", type="redirect"), @Result(name="input", location="attributeManage"), @Result(name="list", location="attributeManage")})
public class AttributeActions
extends BaseAction {
    private static final long serialVersionUID = 1L;
    Long attributeId;
    String attributeName;
    String attributeDescription;
    Boolean checkUniqueness;

    public void validateCreate() {
        VOMSAttributeDescription desc = VOMSAttributeDAO.instance().getAttributeDescriptionByName(this.attributeName);
        if (desc != null) {
            this.addFieldError("attributeName", "Attribute class '" + this.attributeName + "' already exists!");
        }
    }

    @Action(value="create", interceptorRefs={@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "create, delete"})})
    public String create() throws Exception {
        CreateAttributeDescriptionOperation.instance(this.attributeName, this.attributeDescription, this.checkUniqueness).execute();
        return "list";
    }

    @SkipValidation
    @Action(value="delete", interceptorRefs={@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "create, delete"})})
    public String delete() throws Exception {
        DeleteAttributeDescriptionOperation.instance(this.attributeName).execute();
        return "list";
    }

    public Long getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(Long attributeId) {
        this.attributeId = attributeId;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Attribute name is required.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The attribute name field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The attribute description field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(String attributeDescription) {
        this.attributeDescription = attributeDescription;
    }

    public Boolean getCheckUniqueness() {
        return this.checkUniqueness;
    }

    public void setCheckUniqueness(Boolean checkUniqueness) {
        this.checkUniqueness = checkUniqueness;
    }
}

