/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.apiv2;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.Collection;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.json.annotations.JSON;
import org.glite.security.voms.admin.operations.groups.CreateGroupOperation;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.view.actions.BaseAction;

@ParentPackage(value="json")
@Results(value={@Result(name="success", type="json"), @Result(name="input", type="json")})
public class CreateGroupAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    String groupName;
    String groupDescription;

    public String execute() throws Exception {
        if ("".equals(this.groupDescription.trim())) {
            this.groupDescription = null;
        }
        CreateGroupOperation op = CreateGroupOperation.instance(this.groupName, this.groupDescription, false);
        VOMSGroup g = (VOMSGroup)op.execute();
        this.addActionMessage(String.format("Group %s created succesfully.", g.getName()));
        return "success";
    }

    @JSON(serialize=false)
    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a name for the group.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The group name field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @JSON(serialize=false)
    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a description for the group.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The group description field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getGroupDescription() {
        return this.groupDescription;
    }

    public void setGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
    }

    @JSON(serialize=true)
    public Collection<String> getActionMessages() {
        return super.getActionMessages();
    }
}

