/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.admin;

import java.util.List;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.requests.DECISION;
import org.glite.security.voms.admin.operations.requests.HandleVOMembershipRequest;
import org.glite.security.voms.admin.operations.users.FindUserOperation;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.NewVOMembershipRequest;
import org.glite.security.voms.admin.view.actions.admin.DecisionAction;

@Results(value={@Result(name="success", location="pendingRequests.jsp"), @Result(name="input", location="pendingRequests.jsp"), @Result(name="invalid.token", location="pendingRequests.jsp")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class MembershipDecisionAction
extends DecisionAction {
    private static final long serialVersionUID = 1L;
    List<String> approvedGroups;

    protected void validateVOMembershipRequest() {
        NewVOMembershipRequest r = (NewVOMembershipRequest)this.getModel();
        VOMSUser sameDnUser = (VOMSUser)FindUserOperation.instance(r.getRequesterInfo().getCertificateSubject(), r.getRequesterInfo().getCertificateIssuer()).execute();
        if (sameDnUser != null && this.decision.equals("approve")) {
            this.addActionError("A user with such certificate already exists. Please reject such request.");
            this.decision = null;
        }
    }

    protected void stripFalseFromApprovedGroups() {
        if (this.approvedGroups != null) {
            while (this.approvedGroups.contains("false")) {
                this.approvedGroups.remove("false");
            }
        }
    }

    public void validate() {
        if (this.request instanceof NewVOMembershipRequest) {
            this.validateVOMembershipRequest();
        }
    }

    @Override
    public String execute() throws Exception {
        this.stripFalseFromApprovedGroups();
        DECISION theDecision = DECISION.valueOf(this.decision.toUpperCase());
        new HandleVOMembershipRequest((NewVOMembershipRequest)this.request, theDecision, this.approvedGroups).execute();
        this.refreshPendingRequests();
        this.setDecision(null);
        return "success";
    }

    public List<String> getApprovedGroups() {
        return this.approvedGroups;
    }

    public void setApprovedGroups(List<String> approvedGroups) {
        this.approvedGroups = approvedGroups;
    }
}

