/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.acl;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.ACLDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.view.actions.BaseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ACLActionSupport
extends BaseAction
implements Preparable,
ModelDriven<ACL> {
    public static final Logger log = LoggerFactory.getLogger(ACLActionSupport.class);
    private static final long serialVersionUID = 1L;
    Long aclId = -1L;
    Long adminId = -1L;
    ACL model;
    VOMSAdmin admin;
    protected Boolean propagate;

    public void prepare() throws Exception {
        if (this.getModel() == null) {
            if (this.getAclId() != -1L) {
                this.model = ACLDAO.instance().getById(this.getAclId());
            }
            if (this.getAdminId() != -1L) {
                this.admin = VOMSAdminDAO.instance().getById(this.getAdminId());
            }
        }
    }

    public ACL getModel() {
        return this.model;
    }

    public Long getAclId() {
        return this.aclId;
    }

    public void setAclId(Long aclId) {
        this.aclId = aclId;
    }

    public Long getAdminId() {
        return this.adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public VOMSAdmin getAdmin() {
        return this.admin;
    }

    public void setAdmin(VOMSAdmin admin) {
        this.admin = admin;
    }

    public Boolean getPropagate() {
        return this.propagate;
    }

    public void setPropagate(Boolean propagate) {
        this.propagate = propagate;
    }

    protected void limitUnauthenticatedClientPermissions(VOMSPermission perms) {
        if (this.admin.isUnauthenticated()) {
            VOMSPermission permMask = VOMSConfiguration.instance().getUnauthenticatedClientPermissionMask();
            this.addActionMessage("Unauthenticated client permissions limited to: '" + permMask + "' for this context!");
            perms.limitToPermissions(permMask);
        }
    }
}

