/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.util;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.glite.security.voms.admin.error.VOMSException;

public class DNUtil {
    public static String getOpenSSLSubject(X500Principal principal) {
        return OpensslNameUtils.convertFromRfc2253((String)X500NameUtils.getReadableForm((X500Principal)principal), (boolean)false);
    }

    public static String normalizeEmailAddressInDN(String dn) {
        return dn.replaceAll("/(E|e|((E|e|)(mail|mailAddress|mailaddress|MAIL|MAILADDRESS)))=", "/Email=");
    }

    public static String normalizeUIDInDN(String dn) {
        return dn.replaceAll("/(UserId|USERID|userId|userid|uid|Uid)=", "/UID=");
    }

    public static String normalizeDN(String dn) {
        return DNUtil.normalizeUIDInDN(DNUtil.normalizeEmailAddressInDN(dn));
    }

    public static String getEmailAddressFromDN(String dn) {
        Pattern emailPattern = Pattern.compile("Email=([^/]*)");
        Matcher m = emailPattern.matcher(dn);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String getEmailAddressFromExtensions(X509Certificate cert) {
        try {
            Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
            if (altNames == null) {
                return null;
            }
            for (List<?> entry : altNames) {
                int entryType = (Integer)entry.get(0);
                if (entryType != 1) continue;
                return (String)entry.get(1);
            }
        }
        catch (CertificateParsingException e) {
            throw new VOMSException("Error accessing subject alternative names: " + e.getMessage(), e);
        }
        return null;
    }

    public static boolean isRFC2253Conformant(String subjectNameIDValue) {
        return true;
    }

    public static String getBCasX500(String principalString) {
        return DNUtil.getOpenSSLSubject(new X500Principal(principalString));
    }
}

