/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.taglib;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.glite.security.voms.admin.persistence.dao.SearchResults;
import org.glite.security.voms.admin.taglib.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNavBarTag
extends TagSupport {
    public static final String SEARCH_PARAMS_KEY = "searchParams";
    private static final Logger log = LoggerFactory.getLogger(SearchNavBarTag.class);
    String id;
    String searchURL;
    String context;
    String permission;
    String styleClass;
    String disabledLinkStyleClass;
    String linkStyleClass;
    String searchType;
    Map<String, String> searchParams;
    private static final long serialVersionUID = 1L;

    protected String buildURL(String text, int firstResult, int resultsPerPage) throws MalformedURLException {
        StringBuilder url = new StringBuilder(this.searchURL);
        String querySeparator = "?";
        if (url.indexOf(querySeparator) != -1) {
            querySeparator = "&";
        }
        url.append(querySeparator + "searchData.firstResult=" + firstResult);
        if (resultsPerPage > 0) {
            url.append("&searchData.maxResults=" + resultsPerPage);
        }
        if (text != null) {
            url.append("&searchData.text=" + text);
        }
        if (this.getSearchType() != null) {
            url.append("&searchData.type=" + this.getSearchType());
        }
        if (this.searchParams != null) {
            for (String param : this.searchParams.keySet()) {
                url.append(String.format("&%s=%s", param, this.searchParams.get(param)));
            }
        }
        return url.toString();
    }

    protected void writeLink(SearchResults res, int firstResult, int resultsPerPage, String content) throws JspException, IOException {
        String url;
        try {
            url = this.buildURL(res.getSearchString(), firstResult, resultsPerPage);
        }
        catch (MalformedURLException e) {
            throw new JspTagException("Error building searchURL: " + e.getMessage(), (Throwable)e);
        }
        String link = TagUtils.isAuthorized(this.pageContext, this.context, this.permission) ? "<a href=\"" + url + "\" class=\"" + this.linkStyleClass + "\">" + content + "</a>" : "<div class=\"" + this.disabledLinkStyleClass + "\">" + content + "</div>";
        this.pageContext.getOut().write(link);
    }

    protected void writeFirst(SearchResults res) throws JspException, IOException {
        this.writeLink(res, 0, res.getResultsPerPage(), "first");
    }

    protected void writeLast(SearchResults res) throws JspException, IOException {
        this.writeLink(res, res.getCount() - res.getResultsPerPage(), res.getResultsPerPage(), "last");
    }

    protected void writePrevious(SearchResults res) throws JspException, IOException {
        int previousIndex = res.getFirstResult() - res.getResultsPerPage();
        if (previousIndex < 0) {
            previousIndex = 0;
        }
        this.writeLink(res, previousIndex, res.getResultsPerPage(), "&lt;");
    }

    protected void writeNext(SearchResults res) throws JspException, IOException {
        this.writeLink(res, res.getFirstResult() + res.getResultsPerPage(), res.getResultsPerPage(), "&gt;");
    }

    protected void writeResultCount(SearchResults res) throws JspException, IOException {
        String resCount = res.getFirstResult() + 1 + "-" + (res.getFirstResult() + res.getResults().size()) + " of " + res.getCount();
        this.pageContext.getOut().write(resCount);
    }

    public int doStartTag() throws JspException {
        SearchResults results = (SearchResults)this.pageContext.findAttribute(this.id);
        this.searchParams = (Map)this.pageContext.findAttribute(SEARCH_PARAMS_KEY);
        if (results == null) {
            return 0;
        }
        try {
            this.pageContext.getOut().write("<div class=\"" + this.styleClass + "\">\n");
            if (results.getFirstResult() > 0) {
                if (results.getFirstResult() - results.getResultsPerPage() > 0) {
                    this.writeFirst(results);
                }
                this.writePrevious(results);
            }
            this.writeResultCount(results);
            if (results.getRemainingCount() > 0) {
                this.writeNext(results);
                if (results.getRemainingCount() > results.getResultsPerPage()) {
                    this.writeLast(results);
                }
            }
            this.pageContext.getOut().write("</div>");
        }
        catch (IOException e) {
            log.error("Error writing jsp page: " + e.getMessage(), (Throwable)e);
            throw new JspException("Error writing jsp page: " + e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getDisabledLinkStyleClass() {
        return this.disabledLinkStyleClass;
    }

    public void setDisabledLinkStyleClass(String disabledLinkStyleClass) {
        this.disabledLinkStyleClass = disabledLinkStyleClass;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLinkStyleClass() {
        return this.linkStyleClass;
    }

    public void setLinkStyleClass(String linkStyleClass) {
        this.linkStyleClass = linkStyleClass;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getSearchURL() {
        return this.searchURL;
    }

    public void setSearchURL(String searchURL) {
        this.searchURL = searchURL;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }
}

