/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.taglib;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;

public class PageCustomizationTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    String pageName;
    String styleClass;

    public int doStartTag() throws JspException {
        VOMSConfiguration conf;
        assert (this.pageName != null) : "pageName cannot be null!";
        if (this.styleClass == null) {
            this.styleClass = "";
        }
        if ((conf = VOMSConfiguration.instance()).pageHasCustomization(this.pageName)) {
            String customizationFilePath = conf.getCustomizationPageAbsolutePath(this.pageName);
            try {
                String header = "<div class='" + this.styleClass + "'><div class='customized-content-title'>VO customized content</div>\n";
                this.pageContext.getOut().write(header);
                BufferedReader reader = new BufferedReader(new FileReader(customizationFilePath));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.pageContext.getOut().write(line + "\n");
                }
                this.pageContext.getOut().write("</div>");
            }
            catch (FileNotFoundException e) {
                throw new JspException("Customization file not found: " + e.getMessage());
            }
            catch (IOException e) {
                throw new JspException("Error writing customization file content!");
            }
            return 0;
        }
        return 0;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}

