/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.taglib;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;

public class FormatDNTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    String fields;
    String dn;
    private static final String regexTemplate = "=((?:(?:\\/(?!DN|DC|STREET|O|OU|CN|C|L|E|Email|emailAddress|UID|uid))?\\w?:?;?'?\"?`?\\s?\\.?@?-?\\p{L}?\\(?\\)?,?)*)";

    private void write(String s) throws JspTagException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.print(s);
        }
        catch (IOException e) {
            throw new JspTagException("Error writing to jsp writer!");
        }
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public String formatDN() {
        StringBuffer repr = new StringBuffer();
        if (this.fields == null || "".equals(this.fields.trim())) {
            return this.dn;
        }
        String[] fieldsArray = this.fields.trim().split(",");
        for (int i = 0; i < fieldsArray.length; ++i) {
            String regex = fieldsArray[i].trim() + regexTemplate;
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(this.dn);
            while (m.find()) {
                if (i > 0 || repr.length() > 0) {
                    repr.append(",");
                }
                repr.append(fieldsArray[i].trim() + "=");
                String match = m.group().trim();
                repr.append(match.substring(match.indexOf(61) + 1));
            }
        }
        if (repr.length() == 0) {
            return this.dn;
        }
        return repr.toString();
    }

    public int doStartTag() throws JspException {
        if (this.fields == null || VOMSConfiguration.instance().getBoolean("voms.webapp.always-show-full-dns", false)) {
            this.write(this.dn);
        } else {
            StringBuilder element = new StringBuilder();
            element.append("<div class=\"clickable formattedDN \" style=\"display:inline;\"><span title=\"" + this.dn + "\">" + this.formatDN() + "</span>");
            element.append("<span style=\"display:none\">" + this.dn + "</span></div>");
            this.write(element.toString());
        }
        return 0;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }
}

